/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements;

import java.lang.reflect.Type;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.replacements.SnippetSubstitutionNode;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.nodes.MacroNode;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public abstract class SnippetSubstitutionInvocationPlugin<T extends SnippetTemplate.AbstractTemplates>
extends InvocationPlugin.InlineOnlyInvocationPlugin {
    private final Class<T> templateClass;

    public SnippetSubstitutionInvocationPlugin(Class<T> templateClass, String name, Type ... argumentTypes) {
        super(name, argumentTypes);
        this.templateClass = templateClass;
    }

    public abstract SnippetTemplate.SnippetInfo getSnippet(T var1);

    @Override
    public boolean execute(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode[] args) {
        SnippetTemplate.AbstractTemplates templates;
        if (!b.isPluginEnabled(this)) {
            return false;
        }
        if (receiver != null) {
            ValueNode r = receiver.get();
            assert (args[0] == r) : args;
        }
        GraalError.guarantee((templates = (SnippetTemplate.AbstractTemplates)b.getReplacements().getSnippetTemplateCache(this.templateClass)) != null, "Missing templates for %s", this.templateClass);
        SnippetTemplate.SnippetInfo snippet = this.getSnippet(templates);
        MacroNode.MacroParams params = MacroNode.MacroParams.of(b, targetMethod, args);
        SnippetSubstitutionNode node = new SnippetSubstitutionNode(templates, snippet, params);
        node.setConstantArguments(this.getConstantArguments(targetMethod));
        JavaKind returnKind = targetMethod.getSignature().getReturnKind();
        if (returnKind != JavaKind.Void) {
            b.addPush(returnKind, node);
        } else {
            b.add(node);
        }
        return true;
    }

    protected Object[] getConstantArguments(ResolvedJavaMethod targetMethod) {
        return null;
    }
}

