/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements;

import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.nodes.FallbackInvokeWithExceptionNode;
import jdk.graal.compiler.replacements.nodes.MacroNode;
import jdk.graal.compiler.replacements.nodes.MacroWithExceptionNode;
import org.graalvm.collections.UnmodifiableEconomicMap;

@NodeInfo(nameTemplate="SnippetSubstitution#{p#snippet/s}", cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED)
public class SnippetSubstitutionNode
extends MacroWithExceptionNode
implements Lowerable {
    public static final NodeClass<SnippetSubstitutionNode> TYPE = NodeClass.create(SnippetSubstitutionNode.class);
    protected Object[] constantArguments;
    protected final SnippetTemplate.SnippetInfo snippet;
    protected final SnippetTemplate.AbstractTemplates templates;

    public <T extends SnippetTemplate.AbstractTemplates> SnippetSubstitutionNode(T templates, SnippetTemplate.SnippetInfo snippet, MacroNode.MacroParams params) {
        super(TYPE, params);
        this.snippet = snippet;
        this.templates = templates;
    }

    public void setConstantArguments(Object[] arguments) {
        this.constantArguments = arguments;
    }

    @Override
    public void lower(LoweringTool tool) {
        int arg;
        SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.snippet, this.graph().getGuardsStage(), tool.getLoweringStage());
        for (arg = 0; arg < this.arguments.size(); ++arg) {
            args.add(this.snippet.getParameterName(arg), this.arguments.get(arg));
        }
        if (this.constantArguments != null) {
            for (Object argument : this.constantArguments) {
                args.addConst(this.snippet.getParameterName(arg), argument);
                ++arg;
            }
        }
        SnippetTemplate template = this.templates.template(tool, this, args);
        UnmodifiableEconomicMap<Node, Node> duplicates = template.instantiate(tool.getMetaAccess(), this, SnippetTemplate.DEFAULT_REPLACER, args, true);
        for (Node original : duplicates.getKeys()) {
            Node replacement;
            if (!(original instanceof FallbackInvokeWithExceptionNode) || !((replacement = (Node)duplicates.get((Object)original)) instanceof Lowerable)) continue;
            tool.getLowerer().lower(replacement, tool);
        }
    }
}

