/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements;

import java.util.EnumSet;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.GenerateStub;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.replacements.nodes.MemoryKillStubIntrinsicNode;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;

@NodeInfo(allowedUsageTypes={InputType.Memory}, size=NodeSize.SIZE_512, cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="depends on length")
public final class StringLatin1InflateNode
extends MemoryKillStubIntrinsicNode {
    public static final NodeClass<StringLatin1InflateNode> TYPE = NodeClass.create(StringLatin1InflateNode.class);
    public static final LocationIdentity[] KILLED_LOCATIONS_BYTE_CHAR = new LocationIdentity[]{NamedLocationIdentity.getArrayLocation(JavaKind.Byte), NamedLocationIdentity.getArrayLocation(JavaKind.Char)};
    public static final ForeignCallDescriptor STUB = new ForeignCallDescriptor("stringLatin1Inflate", Void.TYPE, new Class[]{Pointer.class, Pointer.class, Integer.TYPE}, ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, KILLED_LOCATIONS_BYTE_CHAR, false, false);
    @Node.Input
    private ValueNode src;
    @Node.Input
    private ValueNode dst;
    @Node.Input
    private ValueNode len;
    private final LocationIdentity[] killedLocations;

    public StringLatin1InflateNode(ValueNode src, ValueNode dst, ValueNode len, JavaKind writeKind) {
        this(src, dst, len, new LocationIdentity[]{NamedLocationIdentity.getArrayLocation(writeKind)}, null);
        GraalError.guarantee(writeKind == JavaKind.Byte || writeKind == JavaKind.Char, "write kind must be either Char or Byte");
    }

    public StringLatin1InflateNode(ValueNode src, ValueNode dst, ValueNode len) {
        this(src, dst, len, KILLED_LOCATIONS_BYTE_CHAR, null);
    }

    public StringLatin1InflateNode(ValueNode src, ValueNode dst, ValueNode len, EnumSet<?> runtimeCheckedCPUFeatures) {
        this(src, dst, len, KILLED_LOCATIONS_BYTE_CHAR, runtimeCheckedCPUFeatures);
    }

    private StringLatin1InflateNode(ValueNode src, ValueNode dst, ValueNode len, LocationIdentity[] killedLocations, EnumSet<?> runtimeCheckedCPUFeatures) {
        super(TYPE, StampFactory.forVoid(), runtimeCheckedCPUFeatures, NamedLocationIdentity.getArrayLocation(JavaKind.Byte));
        this.src = src;
        this.dst = dst;
        this.len = len;
        this.killedLocations = killedLocations;
    }

    @Override
    public LocationIdentity[] getKilledLocationIdentities() {
        return this.killedLocations;
    }

    @Override
    public ForeignCallDescriptor getForeignCallDescriptor() {
        return STUB;
    }

    @Override
    public ValueNode[] getForeignCallArguments() {
        return new ValueNode[]{this.src, this.dst, this.len};
    }

    @Override
    public void emitIntrinsic(NodeLIRBuilderTool gen) {
        gen.getLIRGeneratorTool().emitStringLatin1Inflate(this.runtimeCheckedCPUFeatures, gen.operand(this.src), gen.operand(this.dst), gen.operand(this.len));
    }

    @Node.NodeIntrinsic
    @GenerateStub
    public static native void stringLatin1Inflate(Pointer var0, Pointer var1, int var2);

    @Node.NodeIntrinsic
    public static native void stringLatin1Inflate(Pointer var0, Pointer var1, int var2, @Node.ConstantNodeParameter EnumSet<?> var3);
}

