/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.amd64;

import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.core.common.calc.FloatConvert;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.SnippetAnchorNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.FloatConvertNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.replacements.amd64.AMD64FloatConvertNode;
import org.graalvm.word.LocationIdentity;

public class AMD64ConvertSnippets
implements Snippets {
    @Snippet
    public static int f2i(float input) {
        if (BranchProbabilityNode.probability(0.010000000000000009, Float.isNaN(input))) {
            return 0;
        }
        GuardingNode guard = SnippetAnchorNode.anchor();
        float nonNanInput = PiNode.piCastNonNanFloat(input, guard);
        int result = AMD64FloatConvertNode.convertToInt(FloatConvert.F2I, nonNanInput);
        if (BranchProbabilityNode.probability(0.010000000000000009, result == Integer.MIN_VALUE) && BranchProbabilityNode.unknownProbability((double)input > 0.0)) {
            return Integer.MAX_VALUE;
        }
        return result;
    }

    @Snippet
    public static long f2l(float input) {
        if (BranchProbabilityNode.probability(0.010000000000000009, Float.isNaN(input))) {
            return 0L;
        }
        GuardingNode guard = SnippetAnchorNode.anchor();
        float nonNanInput = PiNode.piCastNonNanFloat(input, guard);
        long result = AMD64FloatConvertNode.convertToLong(FloatConvert.F2L, nonNanInput);
        if (BranchProbabilityNode.probability(0.010000000000000009, result == Long.MIN_VALUE) && BranchProbabilityNode.unknownProbability((double)input > 0.0)) {
            return Long.MAX_VALUE;
        }
        return result;
    }

    @Snippet
    public static int d2i(double input) {
        if (BranchProbabilityNode.probability(0.010000000000000009, Double.isNaN(input))) {
            return 0;
        }
        GuardingNode guard = SnippetAnchorNode.anchor();
        double nonNanInput = PiNode.piCastNonNanDouble(input, guard);
        int result = AMD64FloatConvertNode.convertToInt(FloatConvert.D2I, nonNanInput);
        if (BranchProbabilityNode.probability(0.010000000000000009, result == Integer.MIN_VALUE) && BranchProbabilityNode.unknownProbability(input > 0.0)) {
            return Integer.MAX_VALUE;
        }
        return result;
    }

    @Snippet
    public static long d2l(double input) {
        if (BranchProbabilityNode.probability(0.010000000000000009, Double.isNaN(input))) {
            return 0L;
        }
        GuardingNode guard = SnippetAnchorNode.anchor();
        double nonNanInput = PiNode.piCastNonNanDouble(input, guard);
        long result = AMD64FloatConvertNode.convertToLong(FloatConvert.D2L, nonNanInput);
        if (BranchProbabilityNode.probability(0.010000000000000009, result == Long.MIN_VALUE) && BranchProbabilityNode.unknownProbability(input > 0.0)) {
            return Long.MAX_VALUE;
        }
        return result;
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo f2i;
        private final SnippetTemplate.SnippetInfo f2l;
        private final SnippetTemplate.SnippetInfo d2i;
        private final SnippetTemplate.SnippetInfo d2l;

        public Templates(OptionValues options, Providers providers) {
            super(options, providers);
            this.f2i = this.snippet(providers, AMD64ConvertSnippets.class, "f2i", new LocationIdentity[0]);
            this.f2l = this.snippet(providers, AMD64ConvertSnippets.class, "f2l", new LocationIdentity[0]);
            this.d2i = this.snippet(providers, AMD64ConvertSnippets.class, "d2i", new LocationIdentity[0]);
            this.d2l = this.snippet(providers, AMD64ConvertSnippets.class, "d2l", new LocationIdentity[0]);
        }

        public void lower(FloatConvertNode convert, LoweringTool tool) {
            SnippetTemplate.SnippetInfo key;
            if (!convert.graph().isAfterStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL)) {
                return;
            }
            StructuredGraph graph = convert.graph();
            switch (convert.getFloatConvert()) {
                case F2I: {
                    key = this.f2i;
                    break;
                }
                case F2L: {
                    key = this.f2l;
                    break;
                }
                case D2I: {
                    key = this.d2i;
                    break;
                }
                case D2L: {
                    key = this.d2l;
                    break;
                }
                default: {
                    return;
                }
            }
            IntegerStamp oldRetStamp = (IntegerStamp)convert.stamp(NodeView.DEFAULT);
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(key, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("input", convert.getValue());
            FixedNode oldNext = tool.lastFixedNode().next();
            SnippetTemplate template = this.template(tool, convert, args);
            convert.getDebug().log("Lowering %s in %s: node=%s, template=%s, arguments=%s", (Object)convert.getFloatConvert(), (Object)graph, (Object)convert, (Object)template, (Object)args);
            ValueNode replacer = template.instantiate(tool.getMetaAccess(), convert, SnippetTemplate.DEFAULT_REPLACER, tool, args);
            convert.safeDelete();
            if (replacer.stamp(NodeView.DEFAULT).canBeImprovedWith(oldRetStamp)) {
                PiNode pi = graph.addOrUnique(new PiNode(replacer, (Stamp)oldRetStamp, AbstractBeginNode.prevBegin(oldNext)));
                replacer.replaceAtMatchingUsages(pi, x -> x != pi);
            }
        }
    }
}

