/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.amd64;

import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.calc.FloatConvert;
import jdk.graal.compiler.core.common.type.ArithmeticOpTable;
import jdk.graal.compiler.core.common.type.FloatStamp;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.calc.UnaryArithmeticNode;
import jdk.graal.compiler.nodes.spi.ArithmeticLIRLowerable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.JavaConstant;

@NodeInfo(cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_1)
public final class AMD64FloatConvertNode
extends UnaryArithmeticNode<ArithmeticOpTable.FloatConvertOp>
implements ArithmeticLIRLowerable {
    public static final NodeClass<AMD64FloatConvertNode> TYPE = NodeClass.create(AMD64FloatConvertNode.class);
    protected final FloatConvert op;

    public AMD64FloatConvertNode(FloatConvert op, ValueNode value) {
        super(TYPE, BinaryArithmeticNode.getArithmeticOpTable(value).getFloatConvert(op), value);
        this.op = op;
    }

    @Override
    protected ArithmeticOpTable.UnaryOp<ArithmeticOpTable.FloatConvertOp> getOp(ArithmeticOpTable table) {
        return table.getFloatConvert(this.op);
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        if (forValue.isJavaConstant()) {
            ArithmeticOpTable.UnaryOp<ArithmeticOpTable.FloatConvertOp> floatConvertOp = this.getOp(BinaryArithmeticNode.getArithmeticOpTable(this.value));
            return ConstantNode.forPrimitive(floatConvertOp.foldStamp(forValue.stamp(NodeView.DEFAULT)), floatConvertOp.foldConstant(forValue.asConstant()));
        }
        return this;
    }

    @Override
    public Stamp foldStamp(Stamp newStamp) {
        Stamp resultStamp = super.foldStamp(newStamp);
        if (resultStamp instanceof IntegerStamp) {
            IntegerStamp integerStamp = (IntegerStamp)resultStamp;
            if (newStamp instanceof FloatStamp) {
                boolean canGenerateSpecialValue;
                FloatStamp inputStamp = (FloatStamp)newStamp;
                boolean canBeNan = inputStamp.canBeNaN();
                boolean canBeInfinity = Double.isInfinite(inputStamp.lowerBound()) || Double.isInfinite(inputStamp.upperBound());
                boolean conversionCanOverflow = AMD64FloatConvertNode.integralPartLargerMaxValue(inputStamp, integerStamp) || AMD64FloatConvertNode.integralPartSmallerMinValue(inputStamp, integerStamp);
                boolean bl = canGenerateSpecialValue = canBeNan || canBeInfinity || conversionCanOverflow;
                if (canGenerateSpecialValue) {
                    return resultStamp.meet(this.createInexactCaseStamp());
                }
                return resultStamp;
            }
        }
        return resultStamp.unrestricted();
    }

    private static boolean integralPartLargerMaxValue(FloatStamp stamp, IntegerStamp integerStamp) {
        double upperBound = stamp.upperBound();
        if (Double.isInfinite(upperBound) || Double.isNaN(upperBound)) {
            return true;
        }
        int bits = integerStamp.getBits();
        assert (bits == 32 || bits == 64) : "Must be int or long " + Assertions.errorMessage(stamp, upperBound);
        long maxValue = NumUtil.maxValue(bits);
        return upperBound >= (double)maxValue;
    }

    private static boolean integralPartSmallerMinValue(FloatStamp stamp, IntegerStamp integerStamp) {
        double lowerBound = stamp.lowerBound();
        if (Double.isInfinite(lowerBound) || Double.isNaN(lowerBound)) {
            return true;
        }
        int bits = integerStamp.getBits();
        assert (bits == 32 || bits == 64) : "Must be int or long " + Assertions.errorMessage(stamp, lowerBound);
        long minValue = NumUtil.minValue(bits);
        return lowerBound <= (double)minValue;
    }

    private Stamp createInexactCaseStamp() {
        IntegerStamp intStamp = (IntegerStamp)this.stamp;
        long inexactValue = intStamp.getBits() <= 32 ? 0x80000000L : Long.MIN_VALUE;
        return StampFactory.forConstant((JavaConstant)JavaConstant.forPrimitiveInt((int)intStamp.getBits(), (long)inexactValue));
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        nodeValueMap.setResult(this, gen.emitFloatConvert(this.op, nodeValueMap.operand(this.getValue())));
    }

    @Node.NodeIntrinsic
    public static native int convertToInt(@Node.ConstantNodeParameter FloatConvert var0, float var1);

    @Node.NodeIntrinsic
    public static native long convertToLong(@Node.ConstantNodeParameter FloatConvert var0, float var1);

    @Node.NodeIntrinsic
    public static native int convertToInt(@Node.ConstantNodeParameter FloatConvert var0, double var1);

    @Node.NodeIntrinsic
    public static native long convertToLong(@Node.ConstantNodeParameter FloatConvert var0, double var1);
}

