/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.arraycopy;

import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.UnreachableBeginNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.loop.LoopExpandableNode;
import jdk.graal.compiler.nodes.spi.Simplifiable;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.replacements.arraycopy.ArrayCopySnippets;
import jdk.graal.compiler.replacements.nodes.BasicArrayCopyNode;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(allowedUsageTypes={InputType.Memory})
public final class ArrayCopyWithDelayedLoweringNode
extends BasicArrayCopyNode
implements Simplifiable,
LoopExpandableNode {
    public static final NodeClass<ArrayCopyWithDelayedLoweringNode> TYPE = NodeClass.create(ArrayCopyWithDelayedLoweringNode.class);
    private final ArrayCopySnippets.WorkSnippetID snippet;
    private final GraphState.GuardsStage delayUntil;
    private final boolean canThrow;

    public ArrayCopyWithDelayedLoweringNode(ValueNode src, ValueNode srcPos, ValueNode dest, ValueNode destPos, ValueNode length, ArrayCopySnippets.WorkSnippetID snippet, GraphState.GuardsStage delayUntil, JavaKind elementKind, boolean canThrow) {
        super(TYPE, src, srcPos, dest, destPos, length, elementKind, -6);
        assert (StampTool.isPointerNonNull(src) && StampTool.isPointerNonNull(dest)) : "must have been null checked";
        this.snippet = snippet;
        this.delayUntil = delayUntil;
        this.canThrow = canThrow;
    }

    public static void arraycopy(Object nonNullSrc, int srcPos, Object nonNullDest, int destPos, int length, @Node.ConstantNodeParameter ArrayCopySnippets.WorkSnippetID snippet, @Node.ConstantNodeParameter GraphState.GuardsStage delayUntil, @Node.ConstantNodeParameter JavaKind elementKind) {
        ArrayCopyWithDelayedLoweringNode.arraycopy(nonNullSrc, srcPos, nonNullDest, destPos, length, snippet, delayUntil, elementKind, true);
    }

    public static void arraycopyNonThrowing(Object nonNullSrc, int srcPos, Object nonNullDest, int destPos, int length, @Node.ConstantNodeParameter ArrayCopySnippets.WorkSnippetID snippet, @Node.ConstantNodeParameter GraphState.GuardsStage delayUntil, @Node.ConstantNodeParameter JavaKind elementKind) {
        ArrayCopyWithDelayedLoweringNode.arraycopy(nonNullSrc, srcPos, nonNullDest, destPos, length, snippet, delayUntil, elementKind, false);
    }

    @Node.NodeIntrinsic
    private static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4, @Node.ConstantNodeParameter ArrayCopySnippets.WorkSnippetID var5, @Node.ConstantNodeParameter GraphState.GuardsStage var6, @Node.ConstantNodeParameter JavaKind var7, @Node.ConstantNodeParameter boolean var8);

    public ArrayCopySnippets.WorkSnippetID getSnippet() {
        return this.snippet;
    }

    public boolean reachedRequiredLoweringStage() {
        return this.graph().getGuardsStage().reachedGuardsStage(this.delayUntil);
    }

    @Override
    public void simplify(SimplifierTool tool) {
        if (!this.canThrow && !(this.exceptionEdge() instanceof UnreachableBeginNode)) {
            this.replaceWithNonThrowing();
        }
    }

    @Override
    public boolean mayExpandToLoop() {
        switch (this.snippet) {
            case checkcastArraycopySnippet: 
            case genericArraycopySnippet: {
                return false;
            }
            case exactArraycopyWithExpandedLoopSnippet: {
                return true;
            }
        }
        throw GraalError.shouldNotReachHere("Unkown snippet type " + String.valueOf((Object)this.snippet));
    }
}

