/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.gc;

import jdk.graal.compiler.api.directives.GraalDirectives;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.gc.SerialArrayRangeWriteBarrier;
import jdk.graal.compiler.nodes.gc.SerialWriteBarrier;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.replacements.SnippetCounter;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.replacements.gc.WriteBarrierSnippets;
import jdk.graal.compiler.replacements.nodes.AssertionNode;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.Pointer;

public abstract class SerialWriteBarrierSnippets
extends WriteBarrierSnippets
implements Snippets {
    @Snippet
    public void serialImpreciseWriteBarrier(Object object, @Snippet.ConstantParameter Counters counters, @Snippet.ConstantParameter boolean verifyOnly) {
        if (this.verifyBarrier()) {
            SerialWriteBarrierSnippets.verifyNotArray(object);
        }
        this.serialWriteBarrier(Word.objectToTrackedPointer(object), counters, verifyOnly);
    }

    @Snippet
    public void serialPreciseWriteBarrier(AddressNode.Address address, @Snippet.ConstantParameter Counters counters, @Snippet.ConstantParameter boolean verifyOnly) {
        this.serialWriteBarrier(Word.fromAddress(address), counters, verifyOnly);
    }

    @Snippet
    public void serialArrayRangeWriteBarrier(AddressNode.Address address, long length, @Snippet.ConstantParameter int elementStride) {
        if (BranchProbabilityNode.probability(0.09999999999999998, length == 0L)) {
            return;
        }
        int cardShift = this.cardTableShift();
        Word cardTableAddress = this.cardTableAddress();
        Word start = cardTableAddress.add(SerialWriteBarrierSnippets.getPointerToFirstArrayElement(address, length, elementStride).unsignedShiftRight(cardShift));
        Word end = cardTableAddress.add(SerialWriteBarrierSnippets.getPointerToLastArrayElement(address, length, elementStride).unsignedShiftRight(cardShift));
        Word cur = start;
        do {
            cur.writeByte(0, this.dirtyCardValue(), GC_CARD_LOCATION);
        } while (GraalDirectives.injectIterationCount(10.0, (cur = cur.add(1)).belowOrEqual(end)));
    }

    private void serialWriteBarrier(Pointer ptr, Counters counters, boolean verifyOnly) {
        if (!verifyOnly) {
            counters.serialWriteBarrierCounter.inc();
        }
        Word base = this.cardTableAddress().add(ptr.unsignedShiftRight(this.cardTableShift()));
        if (verifyOnly) {
            byte cardValue = base.readByte(0, GC_CARD_LOCATION);
            AssertionNode.dynamicAssert(cardValue == this.dirtyCardValue(), "card must be dirty");
        } else {
            base.writeByte(0, this.dirtyCardValue(), GC_CARD_LOCATION);
        }
    }

    protected abstract Word cardTableAddress();

    protected abstract int cardTableShift();

    protected abstract boolean verifyBarrier();

    protected abstract byte dirtyCardValue();

    static class Counters {
        final SnippetCounter serialWriteBarrierCounter;

        Counters(SnippetCounter.Group.Factory factory) {
            SnippetCounter.Group countersWriteBarriers = factory.createSnippetCounterGroup("Serial WriteBarriers");
            this.serialWriteBarrierCounter = new SnippetCounter(countersWriteBarriers, "serialWriteBarrier", "Number of Serial Write Barriers");
        }
    }

    public static class SerialWriteBarrierLowerer {
        private final Counters counters;

        public SerialWriteBarrierLowerer(SnippetCounter.Group.Factory factory) {
            this.counters = new Counters(factory);
        }

        public void lower(SnippetTemplate.AbstractTemplates templates, SnippetTemplate.SnippetInfo preciseSnippet, SnippetTemplate.SnippetInfo impreciseSnippet, SerialWriteBarrier barrier, LoweringTool tool) {
            SnippetTemplate.Arguments args;
            if (barrier.usePrecise()) {
                args = new SnippetTemplate.Arguments(preciseSnippet, barrier.graph().getGuardsStage(), tool.getLoweringStage());
                args.add("address", barrier.getAddress());
            } else {
                args = new SnippetTemplate.Arguments(impreciseSnippet, barrier.graph().getGuardsStage(), tool.getLoweringStage());
                OffsetAddressNode address = (OffsetAddressNode)barrier.getAddress();
                args.add("object", address.getBase());
            }
            args.addConst("counters", this.counters);
            args.addConst("verifyOnly", barrier.getVerifyOnly());
            templates.template(tool, barrier, args).instantiate(tool.getMetaAccess(), barrier, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        public void lower(SnippetTemplate.AbstractTemplates templates, SnippetTemplate.SnippetInfo snippet, SerialArrayRangeWriteBarrier barrier, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(snippet, barrier.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("address", barrier.getAddress());
            args.add("length", barrier.getLengthAsLong());
            args.addConst("elementStride", barrier.getElementStride());
            templates.template(tool, barrier, args).instantiate(tool.getMetaAccess(), barrier, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

