/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampPair;
import jdk.graal.compiler.graph.IterableNodeType;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.replacements.nodes.MacroNode;
import jdk.graal.compiler.replacements.nodes.ObjectClone;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="see rationale in MacroNode", size=NodeSize.SIZE_8)
public abstract class BasicObjectCloneNode
extends MacroNode
implements ObjectClone,
IterableNodeType,
Canonicalizable {
    public static final NodeClass<BasicObjectCloneNode> TYPE = NodeClass.create(BasicObjectCloneNode.class);

    public BasicObjectCloneNode(NodeClass<? extends MacroNode> c, MacroNode.MacroParams p) {
        this(c, p, null);
    }

    protected BasicObjectCloneNode(NodeClass<? extends MacroNode> c, MacroNode.MacroParams p, FrameState stateAfter) {
        super(c, BasicObjectCloneNode.maybeImproveReturnStamp(p), stateAfter);
    }

    @Override
    public ValueNode getObject() {
        return (ValueNode)this.arguments.get(0);
    }

    protected static ObjectStamp betterStamp(ValueNode object, Stamp currentStamp) {
        ObjectStamp maybeBetterStamp;
        Stamp stamp = ObjectClone.computeStamp(object, currentStamp);
        if (stamp instanceof ObjectStamp && !(maybeBetterStamp = (ObjectStamp)stamp).equals(currentStamp) && maybeBetterStamp.join(currentStamp).equals(maybeBetterStamp)) {
            return maybeBetterStamp;
        }
        return null;
    }

    protected static MacroNode.MacroParams maybeImproveReturnStamp(MacroNode.MacroParams p) {
        ObjectStamp betterStamp = BasicObjectCloneNode.betterStamp(p.arguments[0], p.returnStamp.getTrustedStamp());
        if (betterStamp != null) {
            return MacroNode.MacroParams.of(p.invokeKind, p.callerMethod, p.targetMethod, p.bci, StampPair.createSingle(betterStamp), p.arguments);
        }
        return p;
    }

    @Override
    public BasicObjectCloneNode canonical(CanonicalizerTool tool) {
        ObjectStamp betterStamp = BasicObjectCloneNode.betterStamp(this.getObject(), this.stamp(NodeView.DEFAULT));
        if (betterStamp != null) {
            return this.duplicateWithNewStamp(betterStamp);
        }
        return this;
    }

    protected abstract BasicObjectCloneNode duplicateWithNewStamp(ObjectStamp var1);
}

