/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import jdk.graal.compiler.core.common.spi.ForeignCallSignature;
import jdk.graal.compiler.core.common.type.FloatStamp;
import jdk.graal.compiler.core.common.type.PrimitiveStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.BinaryNode;
import jdk.graal.compiler.nodes.calc.FloatDivNode;
import jdk.graal.compiler.nodes.calc.MulNode;
import jdk.graal.compiler.nodes.calc.SqrtNode;
import jdk.graal.compiler.nodes.spi.ArithmeticLIRLowerable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;

@NodeInfo(nameTemplate="MathIntrinsic#{p#operation/s}", cycles=NodeCycles.CYCLES_1024, cyclesRationale="stub based math intrinsics all have roughly the same high cycle count", size=NodeSize.SIZE_1)
public final class BinaryMathIntrinsicNode
extends BinaryNode
implements ArithmeticLIRLowerable,
Lowerable {
    public static final NodeClass<BinaryMathIntrinsicNode> TYPE = NodeClass.create(BinaryMathIntrinsicNode.class);
    protected final BinaryOperation operation;

    public BinaryOperation getOperation() {
        return this.operation;
    }

    public static ValueNode create(ValueNode forX, ValueNode forY, BinaryOperation op) {
        ValueNode c = BinaryMathIntrinsicNode.tryConstantFold(forX, forY, op);
        if (c != null) {
            return c;
        }
        return new BinaryMathIntrinsicNode(forX, forY, op);
    }

    protected static ValueNode tryConstantFold(ValueNode forX, ValueNode forY, BinaryOperation op) {
        if (forX.isConstant() && forY.isConstant()) {
            double ret = BinaryMathIntrinsicNode.doCompute(forX.asJavaConstant().asDouble(), forY.asJavaConstant().asDouble(), op);
            return ConstantNode.forDouble(ret);
        }
        return null;
    }

    @Override
    public Stamp foldStamp(Stamp stampX, Stamp stampY) {
        return this.stamp(NodeView.DEFAULT);
    }

    protected BinaryMathIntrinsicNode(ValueNode forX, ValueNode forY, BinaryOperation op) {
        super(TYPE, StampFactory.forKind(JavaKind.Double), forX, forY);
        assert (forX.stamp(NodeView.DEFAULT) instanceof FloatStamp) : Assertions.errorMessageContext("forX", forX);
        assert (PrimitiveStamp.getBits(forX.stamp(NodeView.DEFAULT)) == 64) : Assertions.errorMessageContext("forX", forX);
        assert (forY.stamp(NodeView.DEFAULT) instanceof FloatStamp) : Assertions.errorMessageContext("forY", forY);
        assert (PrimitiveStamp.getBits(forY.stamp(NodeView.DEFAULT)) == 64) : Assertions.errorMessageContext("forY", forY);
        this.operation = op;
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        Value xValue = nodeValueMap.operand(this.getX());
        Value yValue = nodeValueMap.operand(this.getY());
        nodeValueMap.setResult(this, switch (this.getOperation().ordinal()) {
            case 0 -> gen.emitMathPow(xValue, yValue);
            default -> throw GraalError.shouldNotReachHereUnexpectedValue((Object)this.getOperation());
        });
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        NodeView view = NodeView.from(tool);
        ValueNode c = BinaryMathIntrinsicNode.tryConstantFold(forX, forY, this.getOperation());
        if (c != null) {
            return c;
        }
        switch (this.getOperation().ordinal()) {
            case 0: {
                if (!forY.isConstant()) break;
                double yValue = forY.asJavaConstant().asDouble();
                if (yValue == 0.0) {
                    return ConstantNode.forDouble(1.0);
                }
                if (yValue == 1.0) {
                    return this.x;
                }
                if (Double.isNaN(yValue)) {
                    return ConstantNode.forDouble(Double.NaN);
                }
                if (yValue == -1.0) {
                    return new FloatDivNode(ConstantNode.forDouble(1.0), this.x);
                }
                if (yValue == 2.0) {
                    return new MulNode(this.x, this.x);
                }
                if (yValue != 0.5 || !(this.x.stamp(view) instanceof FloatStamp) || !(((FloatStamp)this.x.stamp(view)).lowerBound() >= 0.0)) break;
                return SqrtNode.create(this.x, view);
            }
        }
        return this;
    }

    @Node.NodeIntrinsic
    public static native double compute(double var0, double var2, @Node.ConstantNodeParameter BinaryOperation var4);

    private static double doCompute(double x, double y, BinaryOperation op) {
        switch (op.ordinal()) {
            case 0: {
                return Math.pow(x, y);
            }
        }
        throw new GraalError("unknown op %s", new Object[]{op});
    }

    public static enum BinaryOperation {
        POW(new ForeignCallSignature("arithmeticPow", Double.TYPE, Double.TYPE, Double.TYPE));

        public final ForeignCallSignature foreignCallSignature;

        private BinaryOperation(ForeignCallSignature foreignCallSignature) {
            this.foreignCallSignature = foreignCallSignature;
        }
    }
}

