/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.PrimitiveStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.UnaryNode;
import jdk.graal.compiler.nodes.spi.ArithmeticLIRLowerable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.replacements.nodes.BitScanReverseNode;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class BitScanForwardNode
extends UnaryNode
implements ArithmeticLIRLowerable {
    public static final NodeClass<BitScanForwardNode> TYPE = NodeClass.create(BitScanForwardNode.class);

    public BitScanForwardNode(ValueNode value) {
        super(TYPE, StampFactory.forInteger(JavaKind.Int, 0L, ((PrimitiveStamp)value.stamp(NodeView.DEFAULT)).getBits()), value);
        assert (value.getStackKind() == JavaKind.Int || value.getStackKind() == JavaKind.Long) : Assertions.errorMessage(value);
    }

    @Override
    public Stamp foldStamp(Stamp newStamp) {
        int max;
        int min;
        assert (newStamp.isCompatible(this.getValue().stamp(NodeView.DEFAULT)));
        IntegerStamp valueStamp = (IntegerStamp)newStamp;
        long mask = CodeUtil.mask((int)valueStamp.getBits());
        int firstAlwaysSetBit = BitScanForwardNode.scan(valueStamp.mustBeSet() & mask);
        int firstMaybeSetBit = BitScanForwardNode.scan(valueStamp.mayBeSet() & mask);
        if (firstAlwaysSetBit == -1) {
            int lastMaybeSetBit = BitScanReverseNode.scan(valueStamp.mayBeSet() & mask);
            min = firstMaybeSetBit;
            max = lastMaybeSetBit;
        } else {
            min = firstMaybeSetBit;
            max = firstAlwaysSetBit;
        }
        return StampFactory.forInteger(JavaKind.Int, min, max);
    }

    public static ValueNode tryFold(ValueNode value) {
        JavaConstant c;
        if (value.isConstant() && (c = value.asJavaConstant()).asLong() != 0L) {
            return ConstantNode.forInt(value.getStackKind() == JavaKind.Int ? BitScanForwardNode.scan(c.asInt()) : BitScanForwardNode.scan(c.asLong()));
        }
        return null;
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        ValueNode folded = BitScanForwardNode.tryFold(forValue);
        return folded != null ? folded : this;
    }

    public static int scan(long v) {
        if (v == 0L) {
            return -1;
        }
        return Long.numberOfTrailingZeros(v);
    }

    public static int scan(int v) {
        return BitScanForwardNode.scan(0xFFFFFFFFL & (long)v);
    }

    @Override
    public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool gen) {
        builder.setResult(this, gen.emitBitScanForward(builder.operand(this.getValue())));
    }
}

