/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import java.util.EnumSet;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.GenerateStub;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.replacements.nodes.ForeignCalls;
import jdk.graal.compiler.replacements.nodes.PureFunctionStubIntrinsicNode;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.word.Pointer;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="Cannot estimate the time of a loop", size=NodeSize.SIZE_64)
public final class CountPositivesNode
extends PureFunctionStubIntrinsicNode {
    public static final NodeClass<CountPositivesNode> TYPE = NodeClass.create(CountPositivesNode.class);
    public static final ForeignCallDescriptor STUB = ForeignCalls.pureFunctionForeignCallDescriptor("stringCodingCountPositives", Integer.TYPE, Pointer.class, Integer.TYPE);
    @Node.Input
    protected ValueNode array;
    @Node.Input
    protected ValueNode len;

    public CountPositivesNode(ValueNode array, ValueNode len) {
        this(array, len, null);
    }

    public CountPositivesNode(ValueNode array, ValueNode len, EnumSet<?> runtimeCheckedCPUFeatures) {
        super(TYPE, StampFactory.forKind(JavaKind.Int), runtimeCheckedCPUFeatures, NamedLocationIdentity.getArrayLocation(JavaKind.Byte));
        this.array = array;
        this.len = len;
    }

    @Override
    public ForeignCallDescriptor getForeignCallDescriptor() {
        return STUB;
    }

    @Override
    public ValueNode[] getForeignCallArguments() {
        return new ValueNode[]{this.array, this.len};
    }

    @Override
    public void emitIntrinsic(NodeLIRBuilderTool gen) {
        gen.setResult(this, (Value)gen.getLIRGeneratorTool().emitCountPositives(this.runtimeCheckedCPUFeatures, gen.operand(this.array), gen.operand(this.len)));
    }

    @Node.NodeIntrinsic
    @GenerateStub
    public static native int stringCodingCountPositives(Pointer var0, int var1);

    @Node.NodeIntrinsic
    public static native int stringCodingCountPositives(Pointer var0, int var1, @Node.ConstantNodeParameter EnumSet<?> var2);
}

