/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.UnaryNode;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;

@NodeInfo(cycles=NodeCycles.CYCLES_32, size=NodeSize.SIZE_32)
public final class FloatToHalfFloatNode
extends UnaryNode
implements LIRLowerable {
    public static final NodeClass<FloatToHalfFloatNode> TYPE = NodeClass.create(FloatToHalfFloatNode.class);

    public FloatToHalfFloatNode(ValueNode value) {
        super(TYPE, StampFactory.forKind(JavaKind.Short), value);
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        if (forValue instanceof ConstantNode) {
            float f = forValue.asJavaConstant().asFloat();
            return ConstantNode.forPrimitive((JavaConstant)JavaConstant.forShort((short)Float.floatToFloat16(f)));
        }
        return this;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        Variable result = gen.getLIRGeneratorTool().getArithmetic().emitFloatToHalfFloat(gen.operand(this.getValue()));
        gen.setResult(this, (Value)result);
    }
}

