/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import java.util.EnumSet;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.GenerateStub;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.replacements.nodes.MemoryKillStubIntrinsicNode;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;

@NodeInfo(allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_128, size=NodeSize.SIZE_128)
public class GHASHProcessBlocksNode
extends MemoryKillStubIntrinsicNode {
    public static final NodeClass<GHASHProcessBlocksNode> TYPE = NodeClass.create(GHASHProcessBlocksNode.class);
    public static final LocationIdentity[] KILLED_LOCATIONS = new LocationIdentity[]{NamedLocationIdentity.getArrayLocation(JavaKind.Long)};
    public static final ForeignCallDescriptor STUB = new ForeignCallDescriptor("ghashProcessBlocks", Void.TYPE, new Class[]{Pointer.class, Pointer.class, Pointer.class, Integer.TYPE}, ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, KILLED_LOCATIONS, false, false);
    @Node.Input
    protected ValueNode state;
    @Node.Input
    protected ValueNode hashSubkey;
    @Node.Input
    protected ValueNode data;
    @Node.Input
    protected ValueNode blocks;

    public GHASHProcessBlocksNode(ValueNode state, ValueNode hashSubkey, ValueNode data, ValueNode blocks) {
        this(state, hashSubkey, data, blocks, null);
    }

    public GHASHProcessBlocksNode(ValueNode state, ValueNode hashSubkey, ValueNode data, ValueNode blocks, EnumSet<?> runtimeCheckedCPUFeatures) {
        super(TYPE, StampFactory.forVoid(), runtimeCheckedCPUFeatures, LocationIdentity.any());
        this.state = state;
        this.hashSubkey = hashSubkey;
        this.data = data;
        this.blocks = blocks;
    }

    @Override
    public ValueNode[] getForeignCallArguments() {
        return new ValueNode[]{this.state, this.hashSubkey, this.data, this.blocks};
    }

    @Override
    public LocationIdentity[] getKilledLocationIdentities() {
        return KILLED_LOCATIONS;
    }

    public static EnumSet<AMD64.CPUFeature> minFeaturesAMD64() {
        return EnumSet.of(AMD64.CPUFeature.SSSE3, AMD64.CPUFeature.CLMUL);
    }

    public static EnumSet<AArch64.CPUFeature> minFeaturesAARCH64() {
        return EnumSet.of(AArch64.CPUFeature.PMULL);
    }

    public static boolean isSupported(Architecture arch) {
        if (arch instanceof AMD64) {
            return ((AMD64)arch).getFeatures().containsAll(GHASHProcessBlocksNode.minFeaturesAMD64());
        }
        if (arch instanceof AArch64) {
            return ((AArch64)arch).getFeatures().containsAll(GHASHProcessBlocksNode.minFeaturesAARCH64());
        }
        return false;
    }

    @Node.NodeIntrinsic
    @GenerateStub(name="ghashProcessBlocks", minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64")
    public static native void apply(Pointer var0, Pointer var1, Pointer var2, int var3);

    @Node.NodeIntrinsic
    public static native void apply(Pointer var0, Pointer var1, Pointer var2, int var3, @Node.ConstantNodeParameter EnumSet<?> var4);

    @Override
    public ForeignCallDescriptor getForeignCallDescriptor() {
        return STUB;
    }

    @Override
    public boolean canBeEmitted(Architecture arch) {
        return GHASHProcessBlocksNode.isSupported(arch);
    }

    @Override
    public void emitIntrinsic(NodeLIRBuilderTool gen) {
        gen.getLIRGeneratorTool().emitGHASHProcessBlocks(gen.operand(this.state), gen.operand(this.hashSubkey), gen.operand(this.data), gen.operand(this.blocks));
    }
}

