/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import jdk.graal.compiler.core.common.type.AbstractObjectStamp;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.AbstractStateSplit;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.DeoptBciSupplier;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.vm.ci.meta.JavaConstant;

@NodeInfo
public abstract class IdentityHashCodeNode
extends AbstractStateSplit
implements Canonicalizable,
Lowerable,
SingleMemoryKill,
DeoptBciSupplier {
    public static final NodeClass<IdentityHashCodeNode> TYPE = NodeClass.create(IdentityHashCodeNode.class);
    @Node.Input
    ValueNode object;
    private int bci;

    protected IdentityHashCodeNode(NodeClass<? extends IdentityHashCodeNode> c, ValueNode object, int bci) {
        super((NodeClass<? extends AbstractStateSplit>)c, (Stamp)IntegerStamp.create(32));
        this.object = object;
        this.bci = bci;
    }

    public ValueNode object() {
        return this.object;
    }

    @Override
    public int bci() {
        return this.bci;
    }

    @Override
    public void setBci(int bci) {
        this.bci = bci;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (this.object.isConstant()) {
            assert (this.object.stamp(NodeView.DEFAULT) instanceof AbstractObjectStamp) : Assertions.errorMessage(this.object);
            JavaConstant c = (JavaConstant)this.object.asConstant();
            int identityHashCode = c.isNull() ? 0 : this.getIdentityHashCode(c);
            return ConstantNode.forInt(identityHashCode);
        }
        return this;
    }

    protected abstract int getIdentityHashCode(JavaConstant var1);
}

