/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class LoadSnippetVarargParameterNode
extends FixedWithNextNode
implements Canonicalizable {
    public static final NodeClass<LoadSnippetVarargParameterNode> TYPE = NodeClass.create(LoadSnippetVarargParameterNode.class);
    @Node.Input
    ValueNode index;
    @Node.Input
    NodeInputList<ParameterNode> parameters;

    public LoadSnippetVarargParameterNode(ParameterNode[] locals, ValueNode index, Stamp stamp) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, stamp);
        this.index = index;
        this.parameters = new NodeInputList((Node)this, (Node[])locals);
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        int indexValue;
        if (this.index.isConstant() && (indexValue = this.index.asJavaConstant().asInt()) < this.parameters.size()) {
            return this.parameters.get(indexValue);
        }
        return this;
    }
}

