/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import java.util.Collection;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.StampPair;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.InliningLog;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.InvokeNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.replacements.nodes.MacroInvokable;
import jdk.graal.compiler.replacements.nodes.ResolvedMethodHandleCallTargetNode;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="If this node is not optimized away it will be lowered to a call, which we cannot estimate", size=NodeSize.SIZE_UNKNOWN, sizeRationale="If this node is not optimized away it will be lowered to a call, which we cannot estimate")
public abstract class MacroNode
extends FixedWithNextNode
implements MacroInvokable {
    public static final NodeClass<MacroNode> TYPE = NodeClass.create(MacroNode.class);
    @Node.Input
    protected NodeInputList<ValueNode> arguments;
    @Node.OptionalInput(value=InputType.State)
    protected FrameState stateAfter;
    protected final int bci;
    protected final ResolvedJavaMethod callerMethod;
    protected final ResolvedJavaMethod targetMethod;
    protected final CallTargetNode.InvokeKind invokeKind;
    protected final StampPair returnStamp;
    protected ResolvedJavaMethod originalTargetMethod;
    protected StampPair originalReturnStamp;
    @Node.Input
    NodeInputList<ValueNode> originalArguments;

    protected MacroNode(NodeClass<? extends MacroNode> c, MacroParams p) {
        this(c, p, null);
    }

    protected MacroNode(NodeClass<? extends MacroNode> c, MacroParams p, FrameState stateAfter) {
        super((NodeClass<? extends FixedWithNextNode>)c, p.returnStamp != null ? p.returnStamp.getTrustedStamp() : null);
        this.arguments = new NodeInputList((Node)this, (Node[])p.arguments);
        this.bci = p.bci;
        this.callerMethod = p.callerMethod;
        this.targetMethod = p.targetMethod;
        this.returnStamp = p.returnStamp;
        this.invokeKind = p.invokeKind;
        assert (!BytecodeFrame.isPlaceholderBci((int)p.bci));
        assert (MacroInvokable.assertArgumentCount(this));
        this.originalArguments = new NodeInputList(this);
        this.stateAfter = stateAfter;
    }

    @Override
    public final boolean inferStamp() {
        this.verifyStamp();
        return false;
    }

    protected void verifyStamp() {
        GraalError.guarantee(this.returnStamp.getTrustedStamp().equals(this.stamp(NodeView.DEFAULT)), "Stamp of replaced node %s must be the same as the original Invoke %s, but is %s ", (Object)this, (Object)this.returnStamp.getTrustedStamp(), (Object)this.stamp(NodeView.DEFAULT));
    }

    @Override
    public ResolvedJavaMethod getContextMethod() {
        return this.callerMethod;
    }

    @Override
    public NodeInputList<ValueNode> getArguments() {
        return this.arguments;
    }

    public ValueNode[] toArgumentArray() {
        return this.arguments.toArray((A[])ValueNode.EMPTY_ARRAY);
    }

    @Override
    public int bci() {
        return this.bci;
    }

    @Override
    public ResolvedJavaMethod getTargetMethod() {
        return this.targetMethod;
    }

    @Override
    public CallTargetNode.InvokeKind getInvokeKind() {
        return this.invokeKind;
    }

    @Override
    public StampPair getReturnStamp() {
        return this.returnStamp;
    }

    @Override
    public NodeInputList<ValueNode> getOriginalArguments() {
        return this.originalArguments;
    }

    @Override
    public ResolvedJavaMethod getOriginalTargetMethod() {
        return this.originalTargetMethod;
    }

    @Override
    public StampPair getOriginalReturnStamp() {
        return this.originalReturnStamp;
    }

    @Override
    public FrameState stateAfter() {
        return this.stateAfter;
    }

    @Override
    public void setStateAfter(FrameState x) {
        assert (x == null || x.isAlive()) : "frame state must be in a graph";
        this.updateUsages(this.stateAfter, x);
        this.stateAfter = x;
    }

    @Override
    public final boolean hasSideEffect() {
        return true;
    }

    @Override
    public final LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    @Override
    protected void afterClone(Node other) {
        this.updateInliningLogAfterClone(other);
    }

    @Override
    public Invoke replaceWithInvoke() {
        try (DebugCloseable context = this.withNodeSourcePosition();){
            InliningLog.UpdateScope updateScope = InliningLog.openUpdateScopeTrackingReplacement(this.graph().getInliningLog(), this);
            try {
                InvokeNode invoke = this.createInvoke(true);
                this.graph().replaceFixedWithFixed(this, invoke);
                assert (invoke.verify());
                InvokeNode invokeNode = invoke;
                if (updateScope != null) {
                    updateScope.close();
                }
                return invokeNode;
            }
            catch (Throwable throwable) {
                if (updateScope != null) {
                    try {
                        updateScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    public LocationIdentity getLocationIdentity() {
        return LocationIdentity.any();
    }

    protected InvokeNode createInvoke(boolean verifyStamp) {
        MethodCallTargetNode callTarget = this.createCallTarget();
        InvokeNode invoke = this.graph().add(new InvokeNode((CallTargetNode)callTarget, this.bci, this.getLocationIdentity()));
        if (this.stateAfter() != null) {
            invoke.setStateAfter(this.stateAfter().duplicate());
            if (this.getStackKind() != JavaKind.Void) {
                invoke.stateAfter().replaceFirstInput(this, invoke);
            }
        }
        if (verifyStamp) {
            this.verifyStamp();
        }
        return invoke;
    }

    @Override
    public void addMethodHandleInfo(ResolvedMethodHandleCallTargetNode methodHandle) {
        assert (this.originalArguments.size() == 0 && this.originalReturnStamp == null & this.originalTargetMethod == null) : this;
        this.originalReturnStamp = methodHandle.originalReturnStamp;
        this.originalTargetMethod = methodHandle.originalTargetMethod;
        this.originalArguments.addAll((Collection<ValueNode>)methodHandle.originalArguments);
    }

    public MacroParams copyParams() {
        return new MacroParams(this.invokeKind, this.callerMethod, this.targetMethod, this.bci, this.returnStamp, this.toArgumentArray());
    }

    protected MacroParams copyParamsWithImprovedStamp(ObjectStamp newStamp) {
        GraalError.guarantee(newStamp.join(this.returnStamp.getTrustedStamp()).equals(newStamp), "stamp should improve from %s to %s", (Object)this.returnStamp, (Object)newStamp);
        StampPair improvedReturnStamp = StampPair.createSingle(newStamp);
        return new MacroParams(this.invokeKind, this.callerMethod, this.targetMethod, this.bci, improvedReturnStamp, this.toArgumentArray());
    }

    public static class MacroParams {
        public final CallTargetNode.InvokeKind invokeKind;
        public final ResolvedJavaMethod callerMethod;
        public final ResolvedJavaMethod targetMethod;
        public final int bci;
        public final StampPair returnStamp;
        public final ValueNode[] arguments;

        public MacroParams(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod callerMethod, ResolvedJavaMethod targetMethod, int bci, StampPair returnStamp, ValueNode ... arguments) {
            this.invokeKind = invokeKind;
            this.callerMethod = callerMethod;
            this.targetMethod = targetMethod;
            this.bci = bci;
            this.returnStamp = returnStamp;
            this.arguments = arguments;
        }

        public static MacroParams of(GraphBuilderContext b, ResolvedJavaMethod targetMethod, ValueNode ... arguments) {
            return new MacroParams(b.getInvokeKind(), b.getMethod(), targetMethod, b.bci(), b.getInvokeReturnStamp(b.getAssumptions()), arguments);
        }

        public static MacroParams of(GraphBuilderContext b, ResolvedJavaMethod targetMethod, StampPair returnStamp, ValueNode ... arguments) {
            return new MacroParams(b.getInvokeKind(), b.getMethod(), targetMethod, b.bci(), returnStamp, arguments);
        }

        public static MacroParams of(GraphBuilderContext b, CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ValueNode ... arguments) {
            return new MacroParams(invokeKind, b.getMethod(), targetMethod, b.bci(), b.getInvokeReturnStamp(b.getAssumptions()), arguments);
        }

        public static MacroParams of(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod callerMethod, ResolvedJavaMethod targetMethod, int bci, StampPair returnStamp, ValueNode ... arguments) {
            return new MacroParams(invokeKind, callerMethod, targetMethod, bci, returnStamp, arguments);
        }
    }
}

