/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.replacements.nodes.MacroNode;
import jdk.graal.compiler.replacements.nodes.MacroWithExceptionNode;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

@NodeInfo
public abstract class ReflectionGetCallerClassNode
extends MacroWithExceptionNode
implements Canonicalizable {
    public static final NodeClass<ReflectionGetCallerClassNode> TYPE = NodeClass.create(ReflectionGetCallerClassNode.class);

    protected ReflectionGetCallerClassNode(NodeClass<? extends ReflectionGetCallerClassNode> c, MacroNode.MacroParams p) {
        super(c, p);
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        ConstantNode callerClassNode = this.getCallerClassNode(tool.getMetaAccess(), tool.getConstantReflection());
        if (callerClassNode != null) {
            return callerClassNode;
        }
        return this;
    }

    private ConstantNode getCallerClassNode(MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection) {
        FrameState state = this.stateAfter();
        int n = 1;
        while (state != null) {
            ResolvedJavaMethod method = state.getMethod();
            switch (n) {
                case 0: {
                    throw GraalError.shouldNotReachHere("current frame state does not include the Reflection.getCallerClass frame");
                }
                case 1: {
                    if (this.isCallerSensitive(method)) break;
                    return null;
                }
                default: {
                    if (this.ignoredBySecurityStackWalk(metaAccess, method)) break;
                    ResolvedJavaType callerClass = method.getDeclaringClass();
                    return ConstantNode.forConstant(constantReflection.asJavaClass(callerClass), metaAccess);
                }
            }
            state = state.outerFrameState();
            ++n;
        }
        return null;
    }

    protected abstract boolean isCallerSensitive(ResolvedJavaMethod var1);

    protected abstract boolean ignoredBySecurityStackWalk(MetaAccessProvider var1, ResolvedJavaMethod var2);
}

