/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes.arithmetic;

import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.IterableNodeType;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.BinaryNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.replacements.nodes.arithmetic.IntegerAddExactNode;
import jdk.graal.compiler.replacements.nodes.arithmetic.IntegerAddExactSplitNode;
import jdk.graal.compiler.replacements.nodes.arithmetic.IntegerExactArithmeticSplitNode;
import jdk.graal.compiler.replacements.nodes.arithmetic.IntegerExactOverflowNode;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public final class IntegerAddExactOverflowNode
extends IntegerExactOverflowNode
implements Canonicalizable.BinaryCommutative<ValueNode>,
IterableNodeType {
    public static final NodeClass<IntegerAddExactOverflowNode> TYPE = NodeClass.create(IntegerAddExactOverflowNode.class);

    public IntegerAddExactOverflowNode(ValueNode x, ValueNode y) {
        super(TYPE, x, y);
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        long c;
        if (forX.isConstant() && !forY.isConstant()) {
            return (ValueNode)new IntegerAddExactOverflowNode(forY, forX).canonical(tool);
        }
        if (forX.isConstant() && forY.isConstant()) {
            return IntegerAddExactOverflowNode.canonicalXYconstant(forX, forY);
        }
        if (forY.isConstant() && (c = forY.asJavaConstant().asLong()) == 0L) {
            return LogicConstantNode.forBoolean(false);
        }
        if (!IntegerStamp.addCanOverflow((IntegerStamp)forX.stamp(NodeView.DEFAULT), (IntegerStamp)forY.stamp(NodeView.DEFAULT))) {
            return LogicConstantNode.forBoolean(false);
        }
        return this;
    }

    private static LogicConstantNode canonicalXYconstant(ValueNode forX, ValueNode forY) {
        JavaConstant xConst = forX.asJavaConstant();
        JavaConstant yConst = forY.asJavaConstant();
        assert (xConst.getJavaKind() == yConst.getJavaKind()) : Assertions.errorMessageContext("forX", forX, "forY", forY);
        try {
            if (xConst.getJavaKind() == JavaKind.Int) {
                Math.addExact(xConst.asInt(), yConst.asInt());
            } else {
                assert (xConst.getJavaKind() == JavaKind.Long) : Assertions.errorMessage(forX, forY, xConst, yConst);
                Math.addExact(xConst.asLong(), yConst.asLong());
            }
        }
        catch (ArithmeticException ex) {
            return LogicConstantNode.forBoolean(true);
        }
        return LogicConstantNode.forBoolean(false);
    }

    @Override
    protected IntegerExactArithmeticSplitNode createSplit(Stamp splitStamp, AbstractBeginNode next, AbstractBeginNode overflow) {
        return new IntegerAddExactSplitNode(splitStamp, this.x, this.y, next, overflow);
    }

    @Override
    protected Class<? extends BinaryNode> getCoupledType() {
        return IntegerAddExactNode.class;
    }
}

