/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes.arithmetic;

import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.MulNode;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.graal.compiler.replacements.nodes.arithmetic.BinaryIntegerExactArithmeticSplitNode;
import jdk.vm.ci.meta.Value;

@NodeInfo(cycles=NodeCycles.CYCLES_4, cyclesRationale="mul+cmp", size=NodeSize.SIZE_4)
public final class IntegerMulExactSplitNode
extends BinaryIntegerExactArithmeticSplitNode {
    public static final NodeClass<IntegerMulExactSplitNode> TYPE = NodeClass.create(IntegerMulExactSplitNode.class);

    public IntegerMulExactSplitNode(Stamp stamp, ValueNode x, ValueNode y, AbstractBeginNode next, AbstractBeginNode overflowSuccessor) {
        super(TYPE, stamp, x, y, next, overflowSuccessor);
    }

    @Override
    protected Value generateArithmetic(NodeLIRBuilderTool gen) {
        return gen.getLIRGeneratorTool().getArithmetic().emitMul(gen.operand(this.getX()), gen.operand(this.getY()), true);
    }

    @Override
    public void simplify(SimplifierTool tool) {
        NodeView view = NodeView.from(tool);
        if (!IntegerStamp.multiplicationCanOverflow((IntegerStamp)this.x.stamp(view), (IntegerStamp)this.y.stamp(view))) {
            tool.deleteBranch(this.overflowSuccessor);
            tool.addToWorkList(this.next);
            MulNode replacement = this.graph().unique(new MulNode(this.x, this.y));
            this.graph().replaceSplitWithFloating(this, replacement, this.next);
            tool.addToWorkList(replacement);
        }
    }
}

