/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.serviceprovider;

import java.lang.reflect.Method;
import java.util.List;
import jdk.graal.compiler.core.common.BootstrapMethodIntrospection;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class BootstrapMethodIntrospectionImpl
implements BootstrapMethodIntrospection {
    private final Object wrapped;
    private static final Class<?> bsmClass;
    private static final Method bsmGetMethod;
    private static final Method bsmIsInvokeDynamic;
    private static final Method bsmGetName;
    private static final Method bsmGetType;
    private static final Method bsmGetStaticArguments;

    public BootstrapMethodIntrospectionImpl(Object wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public ResolvedJavaMethod getMethod() {
        try {
            return (ResolvedJavaMethod)bsmGetMethod.invoke(this.wrapped, new Object[0]);
        }
        catch (Throwable t) {
            throw GraalError.shouldNotReachHere(t);
        }
    }

    @Override
    public boolean isInvokeDynamic() {
        try {
            return (Boolean)bsmIsInvokeDynamic.invoke(this.wrapped, new Object[0]);
        }
        catch (Throwable t) {
            throw GraalError.shouldNotReachHere(t);
        }
    }

    @Override
    public String getName() {
        try {
            return (String)bsmGetName.invoke(this.wrapped, new Object[0]);
        }
        catch (Throwable t) {
            throw GraalError.shouldNotReachHere(t);
        }
    }

    @Override
    public JavaConstant getType() {
        try {
            return (JavaConstant)bsmGetType.invoke(this.wrapped, new Object[0]);
        }
        catch (Throwable t) {
            throw GraalError.shouldNotReachHere(t);
        }
    }

    @Override
    public List<JavaConstant> getStaticArguments() {
        try {
            return (List)bsmGetStaticArguments.invoke(this.wrapped, new Object[0]);
        }
        catch (Throwable t) {
            throw GraalError.shouldNotReachHere(t);
        }
    }

    static {
        Class<?> bootstrapMethodClass = null;
        try {
            bootstrapMethodClass = Class.forName("jdk.vm.ci.meta.ConstantPool$BootstrapMethodInvocation");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        bsmClass = bootstrapMethodClass;
        Method bootstrapMethodGetMethod = null;
        Method bootstrapMethodIsInvokeDynamic = null;
        Method bootstrapMethodGetName = null;
        Method bootstrapMethodGetType = null;
        Method bootstrapMethodGetStaticArguments = null;
        try {
            bootstrapMethodGetMethod = bsmClass == null ? null : bsmClass.getMethod("getMethod", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            bootstrapMethodIsInvokeDynamic = bsmClass == null ? null : bsmClass.getMethod("isInvokeDynamic", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            bootstrapMethodGetName = bsmClass == null ? null : bsmClass.getMethod("getName", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            bootstrapMethodGetType = bsmClass == null ? null : bsmClass.getMethod("getType", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            bootstrapMethodGetStaticArguments = bsmClass == null ? null : bsmClass.getMethod("getStaticArguments", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        bsmGetMethod = bootstrapMethodGetMethod;
        bsmIsInvokeDynamic = bootstrapMethodIsInvokeDynamic;
        bsmGetName = bootstrapMethodGetName;
        bsmGetType = bootstrapMethodGetType;
        bsmGetStaticArguments = bootstrapMethodGetStaticArguments;
    }
}

