/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.serviceprovider;

import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class GraalUnsafeAccess {
    private static final Unsafe UNSAFE = GraalUnsafeAccess.initUnsafe();

    private static Unsafe initUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException se) {
            try {
                Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafe.setAccessible(true);
                return (Unsafe)theUnsafe.get(Unsafe.class);
            }
            catch (Exception e) {
                throw new RuntimeException("exception while trying to get Unsafe", e);
            }
        }
    }

    public static Unsafe getUnsafe() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("accessUnsafe"));
        }
        return UNSAFE;
    }
}

