/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle;

import com.oracle.truffle.compiler.TruffleCompilerRuntime;
import java.lang.invoke.MethodHandle;
import java.lang.ref.Reference;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ReadOnlyBufferException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Objects;
import java.util.Set;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.truffle.AbstractKnownTruffleTypes;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public class KnownTruffleTypes
extends AbstractKnownTruffleTypes {
    public final ResolvedJavaType Object_Array = this.lookupType(Object[].class);
    public final ResolvedJavaType java_lang_Object = this.lookupType(Object.class);
    public final ResolvedJavaType Objects = this.lookupType(Objects.class);
    public final ResolvedJavaType MethodHandle = this.lookupType(MethodHandle.class);
    public final ResolvedJavaType Buffer = this.lookupTypeCached(Buffer.class);
    public final ResolvedJavaField Buffer_segment = this.findField(this.lookupType(Buffer.class), "segment");
    public final ResolvedJavaType ArithmeticException = this.lookupType(ArithmeticException.class);
    public final ResolvedJavaType IllegalArgumentException = this.lookupType(IllegalArgumentException.class);
    public final ResolvedJavaType IllegalStateException = this.lookupType(IllegalStateException.class);
    public final ResolvedJavaType VirtualMachineError = this.lookupType(VirtualMachineError.class);
    public final ResolvedJavaType IndexOutOfBoundsException = this.lookupType(IndexOutOfBoundsException.class);
    public final ResolvedJavaType ClassCastException = this.lookupType(ClassCastException.class);
    public final ResolvedJavaType BufferUnderflowException = this.lookupType(BufferUnderflowException.class);
    public final ResolvedJavaType BufferOverflowException = this.lookupType(BufferOverflowException.class);
    public final ResolvedJavaType ReadOnlyBufferException = this.lookupType(ReadOnlyBufferException.class);
    public final ResolvedJavaType ScopedMemoryAccess_ScopedAccessError = this.lookupTypeOptional("jdk.internal.misc.ScopedMemoryAccess$ScopedAccessError");
    public final ResolvedJavaType AbstractMemorySegmentImpl = this.lookupTypeOptional("jdk.internal.foreign.AbstractMemorySegmentImpl");
    public final ResolvedJavaType MemorySegmentProxy = this.lookupTypeOptional("jdk.internal.access.foreign.MemorySegmentProxy");
    public final Set<ResolvedJavaType> primitiveBoxTypes = Set.of(this.lookupType(JavaKind.Boolean.toBoxedJavaClass()), this.lookupType(JavaKind.Byte.toBoxedJavaClass()), this.lookupType(JavaKind.Char.toBoxedJavaClass()), this.lookupType(JavaKind.Double.toBoxedJavaClass()), this.lookupType(JavaKind.Float.toBoxedJavaClass()), this.lookupType(JavaKind.Int.toBoxedJavaClass()), this.lookupType(JavaKind.Long.toBoxedJavaClass()), this.lookupType(JavaKind.Short.toBoxedJavaClass()));
    public final ResolvedJavaField Reference_referent = this.findField(this.lookupTypeCached(Reference.class), "referent");
    public final ResolvedJavaType CompilerDirectives = this.lookupType("com.oracle.truffle.api.CompilerDirectives");
    public final ResolvedJavaType CompilerAsserts = this.lookupType("com.oracle.truffle.api.CompilerAsserts");
    public final ResolvedJavaType ExactMath = this.lookupType("com.oracle.truffle.api.ExactMath");
    public final ResolvedJavaType HostCompilerDirectives = this.lookupType("com.oracle.truffle.api.HostCompilerDirectives");
    public final ResolvedJavaType TruffleSafepoint = this.lookupType("com.oracle.truffle.api.TruffleSafepoint");
    public final ResolvedJavaType RootNode = this.lookupType("com.oracle.truffle.api.nodes.RootNode");
    public final ResolvedJavaType Node = this.lookupTypeCached("com.oracle.truffle.api.nodes.Node");
    public final ResolvedJavaField Node_parent = this.findField(this.Node, "parent");
    public final ResolvedJavaType UnexpectedResultException = this.lookupType("com.oracle.truffle.api.nodes.UnexpectedResultException");
    public final ResolvedJavaType SlowPathException = this.lookupType("com.oracle.truffle.api.nodes.SlowPathException");
    public final ResolvedJavaType VirtualFrame = this.lookupType("com.oracle.truffle.api.frame.VirtualFrame");
    public final ResolvedJavaType FrameDescriptor = this.lookupTypeCached("com.oracle.truffle.api.frame.FrameDescriptor");
    public final ResolvedJavaField FrameDescriptor_defaultValue = this.findField(this.FrameDescriptor, "defaultValue");
    public final ResolvedJavaField FrameDescriptor_materializeCalled = this.findField(this.FrameDescriptor, "materializeCalled");
    public final ResolvedJavaField FrameDescriptor_indexedSlotTags = this.findField(this.FrameDescriptor, "indexedSlotTags");
    public final ResolvedJavaField FrameDescriptor_auxiliarySlotCount = this.findField(this.FrameDescriptor, "auxiliarySlotCount");
    public final ResolvedJavaField FrameDescriptor_staticMode = this.findField(this.FrameDescriptor, "staticMode");
    public final ResolvedJavaType FrameSlotKind = this.lookupTypeCached("com.oracle.truffle.api.frame.FrameSlotKind");
    public final ResolvedJavaField FrameSlotKind_Object = this.findField(this.FrameSlotKind, "Object");
    public final ResolvedJavaField FrameSlotKind_Long = this.findField(this.FrameSlotKind, "Long");
    public final ResolvedJavaField FrameSlotKind_Int = this.findField(this.FrameSlotKind, "Int");
    public final ResolvedJavaField FrameSlotKind_Double = this.findField(this.FrameSlotKind, "Double");
    public final ResolvedJavaField FrameSlotKind_Float = this.findField(this.FrameSlotKind, "Float");
    public final ResolvedJavaField FrameSlotKind_Boolean = this.findField(this.FrameSlotKind, "Boolean");
    public final ResolvedJavaField FrameSlotKind_Byte = this.findField(this.FrameSlotKind, "Byte");
    public final ResolvedJavaField FrameSlotKind_Illegal = this.findField(this.FrameSlotKind, "Illegal");
    public final ResolvedJavaField FrameSlotKind_Static = this.findField(this.FrameSlotKind, "Static");
    public final ResolvedJavaField FrameSlotKind_tag = this.findField(this.FrameSlotKind, "tag");
    public final JavaKind[] FrameSlotKind_tagIndexToJavaKind;
    public final EnumMap<JavaKind, Integer> FrameSlotKind_javaKindToTagIndex;
    public final ResolvedJavaType Shape = this.lookupType("com.oracle.truffle.api.object.Shape");
    public final ResolvedJavaType DynamicObject = this.lookupType("com.oracle.truffle.api.object.DynamicObject");
    public final ResolvedJavaType UnsafeAccess = this.lookupType("com.oracle.truffle.object.UnsafeAccess");
    public final ResolvedJavaType TruffleString = this.lookupType("com.oracle.truffle.api.strings.TruffleString");
    public final ResolvedJavaType AbstractTruffleString = this.lookupTypeCached("com.oracle.truffle.api.strings.AbstractTruffleString");
    public final ResolvedJavaField AbstractTruffleString_data = this.findField(this.AbstractTruffleString, "data");
    public final ResolvedJavaField AbstractTruffleString_hashCode = this.findField(this.AbstractTruffleString, "hashCode");
    public final ResolvedJavaField AbstractTruffleString_codeRange = this.findField(this.AbstractTruffleString, "codeRange");
    public final ResolvedJavaField AbstractTruffleString_codePointLength = this.findField(this.AbstractTruffleString, "codePointLength");
    public final ResolvedJavaType FrameWithoutBoxing = this.lookupTypeCached("com.oracle.truffle.api.impl.FrameWithoutBoxing");
    public final ResolvedJavaField FrameWithoutBoxing_descriptor = this.findField(this.FrameWithoutBoxing, "descriptor");
    public final ResolvedJavaField FrameWithoutBoxing_arguments = this.findField(this.FrameWithoutBoxing, "arguments");
    public final ResolvedJavaField FrameWithoutBoxing_auxiliarySlots = this.findField(this.FrameWithoutBoxing, "auxiliarySlots");
    public final ResolvedJavaField FrameWithoutBoxing_indexedTags = this.findField(this.FrameWithoutBoxing, "indexedTags");
    public final ResolvedJavaField FrameWithoutBoxing_indexedLocals = this.findField(this.FrameWithoutBoxing, "indexedLocals");
    public final ResolvedJavaField FrameWithoutBoxing_indexedPrimitiveLocals = this.findField(this.FrameWithoutBoxing, "indexedPrimitiveLocals");
    public final ResolvedJavaField FrameWithoutBoxing_EMPTY_OBJECT_ARRAY = this.findField(this.FrameWithoutBoxing, "EMPTY_OBJECT_ARRAY");
    public final ResolvedJavaField FrameWithoutBoxing_EMPTY_LONG_ARRAY = this.findField(this.FrameWithoutBoxing, "EMPTY_LONG_ARRAY");
    public final ResolvedJavaField FrameWithoutBoxing_EMPTY_BYTE_ARRAY = this.findField(this.FrameWithoutBoxing, "EMPTY_BYTE_ARRAY");
    public final ResolvedJavaField[] FrameWithoutBoxing_instanceFields = this.findInstanceFields(this.FrameWithoutBoxing);
    public final ResolvedJavaType AbstractAssumption = this.lookupTypeCached("com.oracle.truffle.api.impl.AbstractAssumption");
    public final ResolvedJavaField AbstractAssumption_isValid = this.findField(this.AbstractAssumption, "isValid");
    public final ResolvedJavaType BaseOSRRootNode = this.lookupTypeCached("com.oracle.truffle.runtime.BaseOSRRootNode");
    public final ResolvedJavaField BaseOSRRootNode_loopNode = this.findField(this.BaseOSRRootNode, "loopNode");
    public final ResolvedJavaType CompilationState = this.lookupType("com.oracle.truffle.runtime.CompilationState");
    public final ResolvedJavaType OptimizedCallTarget = this.lookupTypeCached("com.oracle.truffle.runtime.OptimizedCallTarget");
    public final ResolvedJavaMethod OptimizedCallTarget_call = this.findMethod(this.OptimizedCallTarget, "call", this.Object_Array);
    public final ResolvedJavaMethod OptimizedCallTarget_callDirect = this.findMethod(this.OptimizedCallTarget, "callDirect", this.Node, this.Object_Array);
    public final ResolvedJavaMethod OptimizedCallTarget_callInlined = this.findMethod(this.OptimizedCallTarget, "callInlined", this.Node, this.Object_Array);
    public final ResolvedJavaMethod OptimizedCallTarget_callIndirect = this.findMethod(this.OptimizedCallTarget, "callIndirect", this.Node, this.Object_Array);
    public final ResolvedJavaMethod OptimizedCallTarget_callBoundary = this.findMethod(this.OptimizedCallTarget, "callBoundary", this.Object_Array);
    public final ResolvedJavaMethod OptimizedCallTarget_executeRootNode = this.findMethod(this.OptimizedCallTarget, "executeRootNode", this.VirtualFrame, this.CompilationState);
    public final ResolvedJavaMethod OptimizedCallTarget_profiledPERoot = this.findMethod(this.OptimizedCallTarget, "profiledPERoot", this.Object_Array);
    public final ResolvedJavaField OptimizedCallTarget_nodeRewritingAssumption = this.findField(this.OptimizedCallTarget, "nodeRewritingAssumption");
    public final ResolvedJavaField OptimizedCallTarget_validRootAssumption = this.findField(this.OptimizedCallTarget, "validRootAssumption");
    public final ResolvedJavaField OptimizedCallTarget_rootNode = this.findField(this.OptimizedCallTarget, "rootNode");
    public final ResolvedJavaType OptimizedDirectCallNode = this.lookupTypeCached("com.oracle.truffle.runtime.OptimizedDirectCallNode");
    public final ResolvedJavaField OptimizedDirectCallNode_currentCallTarget = this.findField(this.OptimizedDirectCallNode, "currentCallTarget");
    public final ResolvedJavaField OptimizedDirectCallNode_inliningForced = this.findField(this.OptimizedDirectCallNode, "inliningForced");
    public final ResolvedJavaField OptimizedDirectCallNode_callCount = this.findField(this.OptimizedDirectCallNode, "callCount");
    public final ResolvedJavaType OptimizedAssumption = this.lookupType("com.oracle.truffle.runtime.OptimizedAssumption");
    public final ResolvedJavaType[] skippedExceptionTypes = this.createSkippedExceptionTypes();
    public final ResolvedJavaField Throwable_jfrTracing;
    protected final ConstantReflectionProvider constantReflection;
    public static final int JDK = Runtime.version().feature();

    public KnownTruffleTypes(TruffleCompilerRuntime runtime, MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection) {
        super(runtime, metaAccess);
        this.constantReflection = constantReflection;
        this.FrameSlotKind_tagIndexToJavaKind = this.createJavaKindByTagIndex(new ResolvedJavaField[]{this.FrameSlotKind_Object, this.FrameSlotKind_Long, this.FrameSlotKind_Int, this.FrameSlotKind_Double, this.FrameSlotKind_Float, this.FrameSlotKind_Boolean, this.FrameSlotKind_Byte, this.FrameSlotKind_Illegal, this.FrameSlotKind_Static}, new JavaKind[]{JavaKind.Object, JavaKind.Long, JavaKind.Int, JavaKind.Double, JavaKind.Float, JavaKind.Boolean, JavaKind.Byte, JavaKind.Illegal, JavaKind.Illegal});
        this.FrameSlotKind_javaKindToTagIndex = KnownTruffleTypes.createJavaKindMap(this.FrameSlotKind_tagIndexToJavaKind);
        this.Throwable_jfrTracing = KnownTruffleTypes.getThrowableJFRTracingField(metaAccess);
    }

    private static boolean throwableUsesJFRTracing() {
        return JDK >= 22;
    }

    private static ResolvedJavaField getThrowableJFRTracingField(MetaAccessProvider metaAccess) {
        if (KnownTruffleTypes.throwableUsesJFRTracing()) {
            ResolvedJavaType throwableType = metaAccess.lookupJavaType(Throwable.class);
            for (ResolvedJavaField staticField : throwableType.getStaticFields()) {
                if (!staticField.getName().equals("jfrTracing") || !staticField.getType().equals((Object)metaAccess.lookupJavaType(Boolean.TYPE)) || !staticField.isVolatile()) continue;
                return staticField;
            }
            throw GraalError.shouldNotReachHere("Field Throwable.jfrTracing not found. This field was added in JDK-22+24 and must be present. This either means this field was removed in which case this code needs to be adapted or the meta access lookup above failed which should never happen.");
        }
        return null;
    }

    private ResolvedJavaType[] createSkippedExceptionTypes() {
        ArrayList<ResolvedJavaType> types = new ArrayList<ResolvedJavaType>(16);
        types.add(this.UnexpectedResultException);
        types.add(this.SlowPathException);
        if (this.ScopedMemoryAccess_ScopedAccessError != null) {
            types.add(this.ScopedMemoryAccess_ScopedAccessError);
        }
        types.add(this.ArithmeticException);
        types.add(this.IllegalArgumentException);
        types.add(this.IllegalStateException);
        types.add(this.VirtualMachineError);
        types.add(this.IndexOutOfBoundsException);
        types.add(this.ClassCastException);
        types.add(this.BufferUnderflowException);
        types.add(this.BufferOverflowException);
        types.add(this.ReadOnlyBufferException);
        return (ResolvedJavaType[])types.toArray(ResolvedJavaType[]::new);
    }

    private JavaKind[] createJavaKindByTagIndex(ResolvedJavaField[] fields, JavaKind[] kinds) {
        int[] tagIndexes = new int[fields.length];
        int maxValue = -1;
        for (int i = 0; i < fields.length; ++i) {
            ResolvedJavaField field = fields[i];
            JavaConstant constant = this.constantReflection.readFieldValue(field, null);
            tagIndexes[i] = this.constantReflection.readFieldValue(this.FrameSlotKind_tag, constant).asInt();
            maxValue = Math.max(maxValue, tagIndexes[i]);
        }
        JavaKind[] indexToJavaKind = new JavaKind[maxValue + 1];
        for (int i = 0; i < tagIndexes.length; ++i) {
            assert (indexToJavaKind[tagIndexes[i]] == null) : "tag indices must be unique";
            indexToJavaKind[tagIndexes[i]] = kinds[i];
        }
        return indexToJavaKind;
    }

    private static EnumMap<JavaKind, Integer> createJavaKindMap(JavaKind[] tagIndexToJavaKind) {
        EnumMap<JavaKind, Integer> map = new EnumMap<JavaKind, Integer>(JavaKind.class);
        for (int i = 0; i < tagIndexToJavaKind.length; ++i) {
            map.putIfAbsent(tagIndexToJavaKind[i], i);
        }
        return map;
    }
}

