/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle;

import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import jdk.graal.compiler.truffle.PartialEvaluator;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicSet;

public final class PEAgnosticInlineInvokePlugin
implements InlineInvokePlugin {
    private final EconomicSet<Invoke> invokeToTruffleCallNode = EconomicSet.create();
    private final List<Invoke> indirectInvokes = new ArrayList<Invoke>();
    private final PartialEvaluator partialEvaluator;
    private JavaConstant lastDirectCallNode;
    private boolean indirectCall;

    public PEAgnosticInlineInvokePlugin(PartialEvaluator partialEvaluator) {
        this.partialEvaluator = partialEvaluator;
    }

    @Override
    public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext builder, ResolvedJavaMethod original, ValueNode[] arguments) {
        InlineInvokePlugin.InlineInfo inlineInfo = this.partialEvaluator.asInlineInfo(original);
        if (original.equals((Object)this.partialEvaluator.types.OptimizedCallTarget_callDirect)) {
            ValueNode arg0 = arguments[1];
            if (!arg0.isConstant()) {
                GraalError.shouldNotReachHere("The direct call node does not resolve to a constant!");
            }
            this.lastDirectCallNode = (JavaConstant)arg0.asConstant();
            return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
        }
        if (original.equals((Object)this.partialEvaluator.types.OptimizedCallTarget_callIndirect)) {
            this.indirectCall = true;
        }
        return inlineInfo;
    }

    @Override
    public void notifyNotInlined(GraphBuilderContext b, ResolvedJavaMethod original, Invoke invoke) {
        if (original.equals((Object)this.partialEvaluator.types.OptimizedCallTarget_callDirect)) {
            this.invokeToTruffleCallNode.add((Object)invoke);
            this.lastDirectCallNode = null;
        } else if (this.lastDirectCallNode == null && this.indirectCall) {
            this.indirectCall = false;
            this.indirectInvokes.add(invoke);
        }
    }

    public EconomicSet<Invoke> getInvokeToTruffleCallNode() {
        return this.invokeToTruffleCallNode;
    }

    public List<Invoke> getIndirectInvokes() {
        return this.indirectInvokes;
    }
}

