/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle;

import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.nodes.graphbuilderconf.LoopExplosionPlugin;
import jdk.graal.compiler.replacements.ReplacementsImpl;
import jdk.graal.compiler.truffle.PartialEvaluator;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;

final class ParsingInlineInvokePlugin
implements InlineInvokePlugin {
    private final PartialEvaluator partialEvaluator;
    private final ReplacementsImpl replacements;
    private final InvocationPlugins invocationPlugins;
    private final LoopExplosionPlugin loopExplosionPlugin;

    ParsingInlineInvokePlugin(PartialEvaluator partialEvaluator, ReplacementsImpl replacements, InvocationPlugins invocationPlugins, LoopExplosionPlugin loopExplosionPlugin) {
        this.partialEvaluator = partialEvaluator;
        this.replacements = replacements;
        this.invocationPlugins = invocationPlugins;
        this.loopExplosionPlugin = loopExplosionPlugin;
    }

    private boolean hasMethodHandleArgument(ValueNode[] arguments) {
        for (ValueNode argument : arguments) {
            JavaConstant constant;
            if (!argument.isConstant() || (constant = argument.asJavaConstant()).getJavaKind() != JavaKind.Object || !constant.isNonNull() || !this.partialEvaluator.types.MethodHandle.isInstance(constant)) continue;
            return true;
        }
        return false;
    }

    @Override
    public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext builder, ResolvedJavaMethod original, ValueNode[] arguments) {
        if (this.invocationPlugins.lookupInvocation(original, builder.getOptions()) != null || this.replacements.hasSubstitution(original, builder.getOptions())) {
            return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
        }
        if (this.loopExplosionPlugin.loopExplosionKind(original) != LoopExplosionPlugin.LoopExplosionKind.NONE) {
            return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
        }
        InlineInvokePlugin.InlineInfo inlineInfo = this.partialEvaluator.asInlineInfo(original);
        if (!inlineInfo.allowsInlining()) {
            return inlineInfo;
        }
        for (ResolvedJavaMethod neverInlineMethod : this.partialEvaluator.getNeverInlineMethods()) {
            if (!original.equals((Object)neverInlineMethod)) continue;
            return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
        }
        if (this.hasMethodHandleArgument(arguments)) {
            return inlineInfo;
        }
        return null;
    }
}

