/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle;

import com.oracle.truffle.compiler.OptimizedAssumptionDependency;
import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.compiler.TruffleCompilationTask;
import com.oracle.truffle.compiler.TruffleCompiler;
import com.oracle.truffle.compiler.TruffleCompilerAssumptionDependency;
import com.oracle.truffle.compiler.TruffleCompilerListener;
import com.oracle.truffle.compiler.TruffleCompilerRuntime;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.core.CompilationPrinter;
import jdk.graal.compiler.core.CompilationWatchDog;
import jdk.graal.compiler.core.CompilationWrapper;
import jdk.graal.compiler.core.GraalCompiler;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.core.common.CompilationRequestIdentifier;
import jdk.graal.compiler.core.common.RetryableBailoutException;
import jdk.graal.compiler.core.common.util.CompilationAlarm;
import jdk.graal.compiler.core.target.Backend;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugDumpScope;
import jdk.graal.compiler.debug.DiagnosticsOutputDirectory;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.debug.Indent;
import jdk.graal.compiler.debug.LogStream;
import jdk.graal.compiler.debug.MemUseTrackerKey;
import jdk.graal.compiler.debug.TTY;
import jdk.graal.compiler.debug.TimerKey;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.lir.asm.CompilationResultBuilderFactory;
import jdk.graal.compiler.lir.phases.LIRSuites;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.calc.NarrowNode;
import jdk.graal.compiler.nodes.calc.ZeroExtendNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.options.OptionsParser;
import jdk.graal.compiler.phases.OptimisticOptimizations;
import jdk.graal.compiler.phases.PhaseSuite;
import jdk.graal.compiler.phases.tiers.HighTierContext;
import jdk.graal.compiler.phases.tiers.Suites;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.serviceprovider.GraalServices;
import jdk.graal.compiler.truffle.ExpansionStatistics;
import jdk.graal.compiler.truffle.GraphTooBigBailoutException;
import jdk.graal.compiler.truffle.PartialEvaluator;
import jdk.graal.compiler.truffle.PartialEvaluatorConfiguration;
import jdk.graal.compiler.truffle.PerformanceInformationHandler;
import jdk.graal.compiler.truffle.PostPartialEvaluationSuite;
import jdk.graal.compiler.truffle.TruffleAST;
import jdk.graal.compiler.truffle.TruffleCompilation;
import jdk.graal.compiler.truffle.TruffleCompilationIdentifier;
import jdk.graal.compiler.truffle.TruffleCompilerConfiguration;
import jdk.graal.compiler.truffle.TruffleCompilerOptions;
import jdk.graal.compiler.truffle.TruffleCompilerOptionsOptionDescriptors;
import jdk.graal.compiler.truffle.TruffleDebugJavaMethod;
import jdk.graal.compiler.truffle.TruffleInliningScope;
import jdk.graal.compiler.truffle.TruffleTierConfiguration;
import jdk.graal.compiler.truffle.TruffleTierContext;
import jdk.graal.compiler.truffle.nodes.AnyExtendNode;
import jdk.graal.compiler.truffle.nodes.AnyNarrowNode;
import jdk.graal.compiler.truffle.nodes.TruffleAssumption;
import jdk.graal.compiler.truffle.phases.InstrumentPhase;
import jdk.graal.compiler.truffle.phases.InstrumentationSuite;
import jdk.graal.compiler.truffle.phases.TruffleTier;
import jdk.vm.ci.code.BailoutException;
import jdk.vm.ci.code.CompilationRequest;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;

public abstract class TruffleCompilerImpl
implements TruffleCompiler,
CompilationWatchDog.EventHandler {
    public static final int FIRST_TIER_INDEX = 1;
    public static final int LAST_TIER_INDEX = 2;
    static final int NUMBER_OF_CACHED_OPTIONS = 128;
    static final TruffleCompilerOptionsOptionDescriptors OPTION_DESCRIPTORS = new TruffleCompilerOptionsOptionDescriptors();
    protected TruffleCompilerConfiguration config;
    protected final GraphBuilderConfiguration builderConfig;
    protected final PartialEvaluator partialEvaluator;
    protected final TrufflePostCodeInstallationTaskFactory codeInstallationTaskFactory;
    private volatile ExpansionStatistics expansionStatistics;
    private volatile boolean expansionStatisticsInitialized;
    private volatile boolean initialized;
    private TruffleTier truffleTier;
    private static final Map<Long, OptionValues> cachedOptions = Collections.synchronizedMap(new LRUCache(128));
    public static final OptimisticOptimizations Optimizations = OptimisticOptimizations.ALL.remove(OptimisticOptimizations.Optimization.UseExceptionProbability, OptimisticOptimizations.Optimization.RemoveNeverExecutedCode, OptimisticOptimizations.Optimization.UseTypeCheckedInlining, OptimisticOptimizations.Optimization.UseTypeCheckHints);
    public static final TimerKey PartialEvaluationTime = DebugContext.timer("PartialEvaluationTime").doc("Total time spent in the Truffle tier.");
    public static final TimerKey CompilationTime = DebugContext.timer("CompilationTime");
    public static final TimerKey CodeInstallationTime = DebugContext.timer("CodeInstallation");
    public static final TimerKey EncodedGraphCacheEvictionTime = DebugContext.timer("EncodedGraphCacheEvictionTime");
    public static final MemUseTrackerKey PartialEvaluationMemUse = DebugContext.memUseTracker("TrufflePartialEvaluationMemUse");
    public static final MemUseTrackerKey CompilationMemUse = DebugContext.memUseTracker("TruffleCompilationMemUse");
    public static final MemUseTrackerKey CodeInstallationMemUse = DebugContext.memUseTracker("TruffleCodeInstallationMemUse");

    public TruffleCompilerImpl(TruffleCompilerConfiguration config) {
        this.config = config;
        this.codeInstallationTaskFactory = new TrufflePostCodeInstallationTaskFactory();
        for (Backend backend : config.backends()) {
            this.initializeBackend(backend);
        }
        GraphBuilderConfiguration baseConfig = GraphBuilderConfiguration.getDefault(new GraphBuilderConfiguration.Plugins(this.config.plugins()));
        this.builderConfig = baseConfig.withSkippedExceptionTypes(config.types().skippedExceptionTypes).withOmitAssertions(TruffleCompilerOptions.ExcludeAssertions.getDefaultValue()).withBytecodeExceptionMode(GraphBuilderConfiguration.BytecodeExceptionMode.ExplicitOnly).withEagerResolving(true);
        this.partialEvaluator = this.createPartialEvaluator(config);
    }

    public void initializeBackend(Backend backend) {
        backend.addCodeInstallationTask(this.codeInstallationTaskFactory);
    }

    public TruffleCompilerConfiguration getConfig() {
        return this.config;
    }

    protected abstract PartialEvaluator createPartialEvaluator(TruffleCompilerConfiguration var1);

    public abstract TruffleCompilationIdentifier createCompilationIdentifier(TruffleCompilationTask var1, TruffleCompilable var2);

    protected abstract DebugContext createDebugContext(OptionValues var1, CompilationIdentifier var2, TruffleCompilable var3, PrintStream var4);

    public static PartialEvaluatorConfiguration createPartialEvaluatorConfiguration(String name) {
        for (PartialEvaluatorConfiguration candidate : GraalServices.load(PartialEvaluatorConfiguration.class)) {
            if (!candidate.name().equals(name)) continue;
            return candidate;
        }
        throw new GraalError("Cannot find partial evaluation configuration: %s", name);
    }

    public final void doCompile(TruffleCompilationTask task, TruffleCompilable compilable, TruffleCompilerListener listener) {
        try (TruffleCompilation compilation = this.openCompilation(task, compilable);){
            this.doCompile(compilation, listener);
        }
    }

    protected abstract OptionValues getGraalOptions();

    public final void doCompile(TruffleCompilation compilation, TruffleCompilerListener listener) {
        TruffleCompilable compilable = compilation.getCompilable();
        TruffleCompilationTask task = compilation.getTask();
        OptionValues compilerOptions = this.getOrCreateCompilerOptions(compilation.getCompilable());
        try (DebugContext debugContext = this.openDebugContext(compilerOptions, compilation);){
            try (DebugContext.Scope s = TruffleCompilerImpl.maybeOpenTruffleScope(task, compilable, debugContext);){
                TruffleCompilationWrapper truffleCompilationWrapper = new TruffleCompilationWrapper(compilerOptions, this.getDebugOutputDirectory(), this.getCompilationProblemsPerAction(), compilable, task, compilation.getCompilationId(), listener);
                truffleCompilationWrapper.run(debugContext);
            }
            catch (Throwable e) {
                TruffleCompilerImpl.notifyCompilableOfFailure(compilable, e, this.isSuppressedFailure(compilable, e));
            }
        }
    }

    public OptionValues getOrCreateCompilerOptions(TruffleCompilable compilable) throws IllegalArgumentException {
        Long engineId = compilable.engineId();
        return cachedOptions.computeIfAbsent(engineId, id -> {
            OptionValues graalOptions = this.getGraalOptions();
            Map options = compilable.getCompilerOptions();
            EconomicMap<OptionKey<?>, Object> map = TruffleCompilerImpl.parseOptions(options);
            map.putAll(graalOptions.getMap());
            TruffleCompilerOptions.updateValues(graalOptions);
            return new OptionValues((UnmodifiableEconomicMap<OptionKey<?>, Object>)map);
        });
    }

    private static EconomicMap<OptionKey<?>, Object> parseOptions(Map<String, String> options) {
        EconomicMap map = EconomicMap.create();
        for (Map.Entry<String, String> entry : options.entrySet()) {
            String key = entry.getKey();
            String uncheckedValue = entry.getValue();
            OptionDescriptor descriptor = OPTION_DESCRIPTORS.get(key);
            if (descriptor == null) {
                throw new IllegalArgumentException("Invalid option " + key);
            }
            Object value = TruffleCompilerOptions.parseCustom(descriptor, uncheckedValue);
            if (value == null) {
                value = OptionsParser.parseOptionValue(descriptor, uncheckedValue);
            }
            map.put(descriptor.getOptionKey(), value);
        }
        return map;
    }

    public final TruffleCompilation openCompilation(TruffleCompilationTask task, TruffleCompilable compilable) {
        TruffleCompilation compilation = new TruffleCompilation(this.config.runtime(), task, compilable);
        compilation.setCompilationId(this.createCompilationIdentifier(task, compilable));
        return compilation;
    }

    private DebugContext openDebugContext(OptionValues compilerOptions, TruffleCompilation compilation) {
        DebugContext debugContext;
        if (compilation == null) {
            debugContext = new DebugContext.Builder(compilerOptions).build();
        } else {
            TruffleCompilable compilable = compilation.getCompilable();
            debugContext = this.createDebugContext(compilerOptions, compilation.getCompilationId(), compilable, DebugContext.getDefaultLogStream());
        }
        return debugContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(TruffleCompilable compilable, boolean firstInitialization) {
        if (!this.initialized) {
            TruffleCompilerImpl truffleCompilerImpl = this;
            synchronized (truffleCompilerImpl) {
                if (!this.initialized) {
                    try (TTY.Filter ttyFilter = new TTY.Filter(new LogStream(new TruffleCompilation.TTYToPolyglotLoggerBridge(this.config.runtime(), compilable)));){
                        OptionValues compilerOptions = this.getOrCreateCompilerOptions(compilable);
                        this.partialEvaluator.initialize(compilerOptions);
                        this.truffleTier = this.newTruffleTier(compilerOptions);
                        this.initialized = true;
                        if (!TruffleCompilerOptions.FirstTierUseEconomy.getValue(compilerOptions).booleanValue()) {
                            this.config = this.config.withFirstTier(this.config.lastTier());
                        }
                    }
                }
            }
        }
    }

    protected TruffleTier newTruffleTier(OptionValues options) {
        return new TruffleTier(options, this.partialEvaluator, new InstrumentationSuite(this.partialEvaluator.instrumentationCfg, this.config.snippetReflection(), this.partialEvaluator.getInstrumentation()), new PostPartialEvaluationSuite(options, TruffleCompilerOptions.IterativePartialEscape.getValue(options)));
    }

    private static DebugContext.Scope maybeOpenTruffleScope(TruffleCompilationTask task, TruffleCompilable compilable, DebugContext debug) throws Throwable {
        if (debug.getCurrentScopeName().endsWith(".Truffle")) {
            return null;
        }
        return debug.scope((Object)"Truffle", new TruffleDebugJavaMethod(task, compilable));
    }

    private static void notifyCompilableOfFailure(TruffleCompilable compilable, Throwable e, boolean silent) {
        Throwable error = e;
        boolean graphTooBig = false;
        if (error instanceof GraphTooBigBailoutException) {
            Throwable cause = error.getCause();
            if (cause != null) {
                error = cause;
            }
            graphTooBig = true;
        }
        BailoutException bailout = error instanceof BailoutException ? (BailoutException)error : null;
        boolean permanentBailout = bailout != null ? bailout.isPermanent() : false;
        Throwable finalError = error;
        compilable.onCompilationFailed(() -> TruffleCompilable.serializeException((Throwable)finalError), silent, bailout != null, permanentBailout, graphTooBig);
    }

    public void shutdown() {
        ExpansionStatistics histogram;
        InstrumentPhase.Instrumentation ins;
        InstrumentPhase.InstrumentationConfiguration cfg = this.partialEvaluator.instrumentationCfg;
        if (cfg != null && (cfg.instrumentBoundaries || cfg.instrumentBranches) && (ins = this.partialEvaluator.instrumentation) != null) {
            ins.dumpAccessTable();
        }
        if ((histogram = this.expansionStatistics) != null) {
            histogram.onShutdown();
            this.expansionStatistics = null;
        }
    }

    protected abstract DiagnosticsOutputDirectory getDebugOutputDirectory();

    protected abstract Map<CompilationWrapper.ExceptionAction, Integer> getCompilationProblemsPerAction();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ExpansionStatistics getExpansionHistogram(OptionValues options) {
        ExpansionStatistics local = this.expansionStatistics;
        if (local == null && !this.expansionStatisticsInitialized) {
            TruffleCompilerImpl truffleCompilerImpl = this;
            synchronized (truffleCompilerImpl) {
                local = this.expansionStatistics;
                if (local == null) {
                    this.expansionStatistics = local = ExpansionStatistics.create(this.partialEvaluator, options);
                    this.expansionStatisticsInitialized = true;
                }
            }
        }
        return local;
    }

    public void compileAST(DebugContext debug, TruffleCompilable compilable, CompilationIdentifier compilationId, TruffleCompilationTask task, TruffleCompilerListener listener) {
        this.compileAST(new TruffleCompilationWrapper(this.getOrCreateCompilerOptions(compilable), this.getDebugOutputDirectory(), Collections.emptyMap(), compilable, task, compilationId, listener), debug);
    }

    private void compileAST(TruffleCompilationWrapper wrapper, DebugContext debug) {
        TruffleCompilationTask task = wrapper.task;
        TruffleCompilable compilable = wrapper.compilable;
        CompilationPrinter printer = CompilationPrinter.begin(debug.getOptions(), wrapper.compilationId, new TruffleDebugJavaMethod(task, compilable), -1);
        StructuredGraph graph = null;
        try (CompilationAlarm alarm = CompilationAlarm.trackCompilationPeriod(debug.getOptions());
             TruffleInliningScope inlining = TruffleInliningScope.open(debug);){
            graph = this.truffleTier(wrapper, debug);
            graph.checkCancellation();
            String compilationName = wrapper.compilable.toString() + (task.isFirstTier() ? "#1" : "#2");
            PhaseSuite<HighTierContext> graphBuilderSuite = this.createGraphBuilderSuite(task.isFirstTier() ? this.config.firstTier() : this.config.lastTier());
            InstalledCode[] installedCode = new InstalledCode[]{null};
            CompilationResult compilationResult = this.compilePEGraph(graph, compilationName, graphBuilderSuite, wrapper.compilable, CompilationRequestIdentifier.asCompilationRequest(wrapper.compilationId), wrapper.listener, task, installedCode, inlining);
            if (wrapper.statistics != null) {
                wrapper.statistics.afterLowTier(wrapper.compilable, graph);
            }
            if (wrapper.listener != null) {
                wrapper.listener.onSuccess(wrapper.compilable, task, (TruffleCompilerListener.GraphInfo)new GraphInfoImpl(graph), (TruffleCompilerListener.CompilationResultInfo)new CompilationResultInfoImpl(compilationResult), task.tier());
            }
            printer.finish(compilationResult, installedCode[0]);
        }
        catch (Throwable t) {
            if (wrapper.listener != null) {
                BailoutException bailout = t instanceof BailoutException ? (BailoutException)t : null;
                boolean permanentBailout = bailout != null ? bailout.isPermanent() : false;
                wrapper.listener.onFailure(compilable, t.toString(), bailout != null, permanentBailout, task.tier());
            }
            throw t;
        }
    }

    private StructuredGraph truffleTier(TruffleCompilationWrapper wrapper, DebugContext debug) {
        StructuredGraph graph;
        try (DebugCloseable a = PartialEvaluationTime.start(debug);
             DebugCloseable c = PartialEvaluationMemUse.start(debug);
             PerformanceInformationHandler handler = PerformanceInformationHandler.install(this.config.runtime(), wrapper.compilerOptions);){
            TruffleTierContext context = new TruffleTierContext(this.partialEvaluator, wrapper.compilerOptions, debug, wrapper.compilable, this.partialEvaluator.rootForCallTarget(wrapper.compilable), wrapper.compilationId, TruffleTierContext.getSpeculationLog(wrapper), wrapper.task, handler);
            wrapper.graph = context.graph;
            try (DebugContext.Scope s = context.debug.scope((Object)"CreateGraph", context.graph);
                 Indent indent = context.debug.logAndIndent("evaluate %s", context.graph);){
                this.truffleTier.apply(context.graph, context);
                graph = context.graph;
            }
            catch (Throwable e) {
                throw context.debug.handle(e);
            }
        }
        if (wrapper.statistics != null) {
            wrapper.statistics.afterTruffleTier(wrapper.compilable, graph);
        }
        if (wrapper.listener != null) {
            wrapper.listener.onTruffleTierFinished(wrapper.compilable, wrapper.task, (TruffleCompilerListener.GraphInfo)new GraphInfoImpl(graph));
        }
        return graph;
    }

    private static void replaceAnyExtendNodes(StructuredGraph graph) {
        for (AnyExtendNode anyExtendNode : graph.getNodes(AnyExtendNode.TYPE)) {
            anyExtendNode.replaceAndDelete(graph.addOrUnique(ZeroExtendNode.create(anyExtendNode.getValue(), 64, NodeView.DEFAULT)));
        }
        for (AnyNarrowNode anyNarrowNode : graph.getNodes(AnyNarrowNode.TYPE)) {
            anyNarrowNode.replaceAndDelete(graph.addOrUnique(NarrowNode.create(anyNarrowNode.getValue(), 32, NodeView.DEFAULT)));
        }
    }

    public CompilationResult compilePEGraph(StructuredGraph graph, String name, PhaseSuite<HighTierContext> graphBuilderSuite, TruffleCompilable compilable, CompilationRequest compilationRequest, TruffleCompilerListener listener, TruffleCompilationTask task, InstalledCode[] outInstalledCode, TruffleInliningScope inlining) {
        DebugCloseable a;
        TruffleCompilerImpl.replaceAnyExtendNodes(graph);
        DebugContext debug = graph.getDebug();
        try (DebugContext.Scope s = debug.scope("TruffleFinal");){
            debug.dump(1, graph, "After TruffleTier");
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        if (debug.isDumpEnabled(1)) {
            debug.dump(1, TruffleAST.create(this.partialEvaluator, task, compilable, inlining != null ? inlining.getCallTree() : null), "After TruffleTier");
        }
        CompilationResult result = null;
        TruffleTierConfiguration tier = task.isFirstTier() ? this.config.firstTier() : this.config.lastTier();
        try {
            a = CompilationTime.start(debug);
            try (DebugContext.Scope s = debug.scope("TruffleGraal.GraalCompiler", graph, tier.providers().getCodeCache());
                 DebugCloseable c = CompilationMemUse.start(debug);){
                Suites selectedSuites = tier.suites();
                LIRSuites selectedLirSuites = tier.lirSuites();
                Providers selectedProviders = tier.providers();
                CompilationResult compilationResult = this.createCompilationResult(name, graph.compilationId(), compilable);
                result = GraalCompiler.compileGraph(graph, graph.method(), selectedProviders, tier.backend(), graphBuilderSuite, Optimizations, graph.getProfilingInfo(), selectedSuites, selectedLirSuites, compilationResult, CompilationResultBuilderFactory.Default, false);
            }
            finally {
                if (a != null) {
                    a.close();
                }
            }
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        if (listener != null) {
            listener.onGraalTierFinished(compilable, (TruffleCompilerListener.GraphInfo)new GraphInfoImpl(graph));
        }
        try {
            a = CodeInstallationTime.start(debug);
            try (DebugCloseable c = CodeInstallationMemUse.start(debug);){
                InstalledCode installedCode = this.createInstalledCode(compilable);
                assert (graph.getSpeculationLog() == result.getSpeculationLog()) : Assertions.errorMessage(graph, graph.getSpeculationLog(), result, result.getSpeculationLog());
                tier.backend().createInstalledCode(debug, graph.method(), compilationRequest, result, installedCode, false);
                if (outInstalledCode != null) {
                    outInstalledCode[0] = installedCode;
                }
            }
            finally {
                if (a != null) {
                    a.close();
                }
            }
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        return result;
    }

    protected abstract InstalledCode createInstalledCode(TruffleCompilable var1);

    protected void exitHostVM(int status) {
        System.exit(status);
    }

    protected abstract CompilationResult createCompilationResult(String var1, CompilationIdentifier var2, TruffleCompilable var3);

    public abstract PhaseSuite<HighTierContext> createGraphBuilderSuite(TruffleTierConfiguration var1);

    public PartialEvaluator getPartialEvaluator() {
        return this.partialEvaluator;
    }

    public TruffleTier getTruffleTier() {
        return this.truffleTier;
    }

    public TruffleCompilable asCompilableTruffleAST(JavaConstant constant) {
        return this.config.snippetReflection().asObject(TruffleCompilable.class, constant);
    }

    @Override
    public void onStuckCompilation(CompilationWatchDog watchDog, Thread watched, CompilationIdentifier compilation, StackTraceElement[] stackTrace, int stuckTime) {
        CompilationWatchDog.EventHandler.super.onStuckCompilation(watchDog, watched, compilation, stackTrace, stuckTime);
        TTY.println("Compilation %s on %s appears stuck - exiting VM", compilation, watched);
        this.exitHostVM(84);
    }

    private boolean isSuppressedFailure(TruffleCompilable compilable, Throwable cause) {
        return this.config.runtime().isSuppressedFailure(compilable, () -> TruffleCompilable.serializeException((Throwable)cause));
    }

    protected TruffleCompilable getCompilable(CompilationResult result) {
        return null;
    }

    protected void afterCodeInstallation(CompilationResult result, InstalledCode installedCode) {
    }

    public final SnippetReflectionProvider getSnippetReflection() {
        return this.config.snippetReflection();
    }

    private class TrufflePostCodeInstallationTaskFactory
    extends Backend.CodeInstallationTaskFactory {
        private TrufflePostCodeInstallationTaskFactory() {
        }

        @Override
        public Backend.CodeInstallationTask create() {
            return new TruffleCodeInstallationTask();
        }
    }

    final class TruffleCompilationWrapper
    extends CompilationWrapper<Void> {
        final TruffleCompilable compilable;
        final TruffleCompilationTask task;
        final TruffleCompilerListener listener;
        final CompilationIdentifier compilationId;
        final ExpansionStatistics statistics;
        final OptionValues compilerOptions;
        StructuredGraph graph;
        boolean silent;

        private TruffleCompilationWrapper(OptionValues compilerOptions, DiagnosticsOutputDirectory outputDirectory, Map<CompilationWrapper.ExceptionAction, Integer> problemsHandledPerAction, TruffleCompilable optimizedCallTarget, TruffleCompilationTask task, CompilationIdentifier compilationId, TruffleCompilerListener listener) {
            super(outputDirectory, problemsHandledPerAction);
            this.compilerOptions = compilerOptions;
            this.compilable = optimizedCallTarget;
            this.task = task;
            this.listener = listener;
            this.compilationId = compilationId;
            this.statistics = TruffleCompilerImpl.this.getExpansionHistogram(compilerOptions);
        }

        @Override
        public String toString() {
            return this.compilable.toString();
        }

        @Override
        protected void dumpOnError(DebugContext errorContext, Throwable cause) {
            if (this.graph != null) {
                try (DebugContext.Scope s = errorContext.scope("DumpOnError", this.graph, this.compilationId, new DebugDumpScope("Original failure"));){
                    errorContext.forceDump(this.graph, "Exception: %s", cause);
                }
                catch (Throwable t) {
                    throw errorContext.handle(t);
                }
            }
        }

        @Override
        protected CompilationWrapper.ExceptionAction lookupAction(OptionValues options, Throwable cause) {
            if ((!(cause instanceof BailoutException) || ((BailoutException)cause).isPermanent()) && TruffleCompilerOptions.DiagnoseFailure.getValue(this.compilerOptions).booleanValue()) {
                return CompilationWrapper.ExceptionAction.Diagnose;
            }
            return super.lookupAction(options, cause);
        }

        @Override
        protected DebugContext createRetryDebugContext(DebugContext initialDebug, OptionValues options, PrintStream logStream) {
            this.listener.onCompilationRetry(this.compilable, this.task);
            return TruffleCompilerImpl.this.createDebugContext(options, this.compilationId, this.compilable, logStream);
        }

        @Override
        protected void exitHostVM(int status) {
            TruffleCompilerImpl.this.exitHostVM(status);
        }

        @Override
        protected Void handleException(Throwable t) {
            TruffleCompilerImpl.notifyCompilableOfFailure(this.compilable, t, this.silent);
            return null;
        }

        @Override
        protected Void performCompilation(DebugContext debug) {
            try (CompilationWatchDog watch = CompilationWatchDog.watch(this.compilationId, debug.getOptions(), false, TruffleCompilerImpl.this);){
                TruffleCompilerImpl.this.compileAST(this, debug);
                Void void_ = null;
                return void_;
            }
        }

        @Override
        protected Void onCompilationFailure(CompilationWrapper.Failure failure) {
            this.silent = TruffleCompilerImpl.this.isSuppressedFailure(this.compilable, failure.cause);
            failure.handle(this.silent);
            return null;
        }
    }

    static class GraphInfoImpl
    implements TruffleCompilerListener.GraphInfo {
        private final StructuredGraph graph;

        GraphInfoImpl(StructuredGraph graph) {
            this.graph = graph;
        }

        public int getNodeCount() {
            return this.graph.getNodeCount();
        }

        public String[] getNodeTypes(boolean simpleNames) {
            String[] res = new String[this.graph.getNodeCount()];
            int i = 0;
            for (Node node : this.graph.getNodes()) {
                res[i++] = simpleNames ? node.getClass().getSimpleName() : node.getClass().getName();
            }
            return res;
        }
    }

    static class CompilationResultInfoImpl
    implements TruffleCompilerListener.CompilationResultInfo {
        private final CompilationResult compResult;

        CompilationResultInfoImpl(CompilationResult compResult) {
            this.compResult = compResult;
        }

        public int getTargetCodeSize() {
            return this.compResult.getTargetCodeSize();
        }

        public int getTotalFrameSize() {
            return this.compResult.getTotalFrameSize();
        }

        public int getExceptionHandlersCount() {
            return this.compResult.getExceptionHandlers().size();
        }

        public int getInfopointsCount() {
            return this.compResult.getInfopoints().size();
        }

        public String[] getInfopoints() {
            List<Infopoint> infopoints = this.compResult.getInfopoints();
            String[] res = new String[infopoints.size()];
            int i = 0;
            for (Infopoint infopoint : infopoints) {
                res[i++] = infopoint.reason.toString();
            }
            return res;
        }

        public int getMarksCount() {
            return this.compResult.getMarks().size();
        }

        public int getDataPatchesCount() {
            return this.compResult.getDataPatches().size();
        }
    }

    private static final class LRUCache<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 7813848977534444613L;
        private final int maxCacheSize;

        LRUCache(int maxCacheSize) {
            this(maxCacheSize, 16);
        }

        LRUCache(int maxCacheSize, int initialCapacity) {
            super(initialCapacity, 0.75f, true);
            this.maxCacheSize = maxCacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxCacheSize;
        }
    }

    private final class TruffleCodeInstallationTask
    extends Backend.CodeInstallationTask {
        private final List<Consumer<OptimizedAssumptionDependency>> optimizedAssumptions = new ArrayList<Consumer<OptimizedAssumptionDependency>>();

        private TruffleCodeInstallationTask() {
        }

        @Override
        public void preProcess(CompilationResult result) {
            if (result == null || result.getAssumptions() == null) {
                return;
            }
            TruffleCompilerRuntime runtime = TruffleCompilerImpl.this.config.runtime();
            ArrayList<Assumptions.Assumption> newAssumptions = new ArrayList<Assumptions.Assumption>();
            for (Assumptions.Assumption assumption : result.getAssumptions()) {
                if (assumption != null && assumption instanceof TruffleAssumption) {
                    TruffleAssumption truffleAssumption = (TruffleAssumption)assumption;
                    Consumer dep = runtime.registerOptimizedAssumptionDependency(truffleAssumption.getAssumption());
                    if (dep == null) {
                        this.notifyAssumptions(null);
                        throw new RetryableBailoutException("Assumption invalidated while compiling code: %s", new Object[]{truffleAssumption});
                    }
                    this.optimizedAssumptions.add(dep);
                    continue;
                }
                newAssumptions.add(assumption);
            }
            result.setAssumptions(newAssumptions.toArray(new Assumptions.Assumption[newAssumptions.size()]));
        }

        @Override
        public void postProcess(CompilationResult compilationResult, InstalledCode installedCode) {
            TruffleCompilerImpl.this.afterCodeInstallation(compilationResult, installedCode);
            if (!this.optimizedAssumptions.isEmpty()) {
                OptimizedAssumptionDependency dependency;
                if (installedCode instanceof OptimizedAssumptionDependency) {
                    dependency = (OptimizedAssumptionDependency)installedCode;
                } else {
                    TruffleCompilable compilable = TruffleCompilerImpl.this.getCompilable(compilationResult);
                    dependency = new TruffleCompilerAssumptionDependency(compilable, installedCode);
                }
                this.notifyAssumptions(dependency);
            }
        }

        @Override
        public void installFailed(Throwable t) {
            this.notifyAssumptions(null);
        }

        private void notifyAssumptions(OptimizedAssumptionDependency dependency) {
            ArrayList<Throwable> errors = null;
            for (Consumer<OptimizedAssumptionDependency> entry : this.optimizedAssumptions) {
                try {
                    entry.accept(dependency);
                }
                catch (Throwable t) {
                    if (errors == null) {
                        errors = new ArrayList<Throwable>();
                    }
                    errors.add(t);
                }
            }
            if (errors != null) {
                StringBuilder sb = new StringBuilder("There were errors while notifying assumptions:");
                for (Throwable e : errors) {
                    e.printStackTrace();
                    sb.append(System.lineSeparator()).append("  ").append(e);
                }
                throw new RetryableBailoutException(sb.toString());
            }
        }
    }
}

