/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.host;

import java.util.ListIterator;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.PhaseSuite;
import jdk.graal.compiler.phases.common.HighTierLoweringPhase;
import jdk.graal.compiler.phases.tiers.HighTierContext;
import jdk.graal.compiler.truffle.host.TruffleHostEnvironment;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;

public final class InjectImmutableFrameFieldsPhase
extends BasePhase<HighTierContext> {
    InjectImmutableFrameFieldsPhase() {
    }

    @Override
    protected void run(StructuredGraph graph, HighTierContext context) {
        TruffleHostEnvironment env = TruffleHostEnvironment.get(graph.method());
        if (env == null) {
            return;
        }
        ResolvedJavaType frameType = env.types().FrameWithoutBoxing;
        for (Node node : graph.getNodes()) {
            LoadFieldNode fieldNode;
            if (!(node instanceof LoadFieldNode) || !InjectImmutableFrameFieldsPhase.isForcedImmutable(env, (fieldNode = (LoadFieldNode)node).field(), frameType) || fieldNode.getLocationIdentity().isImmutable()) continue;
            graph.replaceFixedWithFixed(fieldNode, graph.add(LoadFieldNode.createOverrideImmutable(fieldNode)));
        }
    }

    private static boolean isForcedImmutable(TruffleHostEnvironment env, ResolvedJavaField field, ResolvedJavaType frameType) {
        if (env == null) {
            return false;
        }
        if (field.isStatic()) {
            return false;
        }
        if (!field.isFinal()) {
            return false;
        }
        if (field.isVolatile()) {
            return false;
        }
        return field.getDeclaringClass().equals((Object)frameType);
    }

    public static void install(PhaseSuite<HighTierContext> highTier, OptionValues options) {
        if (Options.TruffleImmutableFrameFields.getValue(options).booleanValue()) {
            ListIterator<BasePhase<HighTierContext>> phase = highTier.findPhase(HighTierLoweringPhase.class);
            phase.previous();
            phase.add(new InjectImmutableFrameFieldsPhase());
        }
    }

    public static class Options {
        public static final OptionKey<Boolean> TruffleImmutableFrameFields = new OptionKey<Boolean>(true);
    }
}

