/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.hotspot;

import com.oracle.truffle.compiler.ConstantFieldInfo;
import com.oracle.truffle.compiler.PartialEvaluationMethodInfo;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import jdk.graal.compiler.core.common.util.FieldKey;
import jdk.graal.compiler.core.common.util.MethodKey;
import jdk.graal.compiler.hotspot.HotSpotGraalServices;
import jdk.graal.compiler.nodes.EncodedGraph;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.truffle.PartialEvaluator;
import jdk.graal.compiler.truffle.TruffleCompilerConfiguration;
import jdk.graal.compiler.truffle.TruffleElementCache;
import jdk.graal.compiler.truffle.hotspot.HotSpotKnownTruffleTypes;
import jdk.graal.compiler.truffle.hotspot.HotSpotTruffleGraphBuilderPlugins;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;

public final class HotSpotPartialEvaluator
extends PartialEvaluator {
    private static final int CONSTANT_INFO_CACHE_SIZE = 1024;
    private static final int METHOD_INFO_CACHE_SIZE = 1024;
    private final AtomicReference<EconomicMap<ResolvedJavaMethod, EncodedGraph>> graphCacheRef;
    private int jvmciReservedReference0Offset = -1;
    private boolean disableEncodedGraphCachePurges = false;
    private final PartialEvaluationMethodInfoCache methodInfoCache = new PartialEvaluationMethodInfoCache();
    private final ConstantFieldInfoCache constantInfoCache = new ConstantFieldInfoCache();
    private final ConcurrentMap<PartialEvaluationMethodInfo, PartialEvaluationMethodInfo> canonicalMethodInfos = new ConcurrentHashMap<PartialEvaluationMethodInfo, PartialEvaluationMethodInfo>();

    public HotSpotPartialEvaluator(TruffleCompilerConfiguration config, GraphBuilderConfiguration configForRoot) {
        super(config, configForRoot);
        this.graphCacheRef = new AtomicReference();
    }

    void setJvmciReservedReference0Offset(int jvmciReservedReference0Offset) {
        this.jvmciReservedReference0Offset = jvmciReservedReference0Offset;
    }

    public int getJvmciReservedReference0Offset() {
        return this.jvmciReservedReference0Offset;
    }

    @Override
    protected void initialize(OptionValues options) {
        super.initialize(options);
    }

    @Override
    public ConstantFieldInfo getConstantFieldInfo(ResolvedJavaField field) {
        return (ConstantFieldInfo)this.constantInfoCache.get(field);
    }

    @Override
    public PartialEvaluationMethodInfo getMethodInfo(ResolvedJavaMethod method) {
        return (PartialEvaluationMethodInfo)this.methodInfoCache.get(method);
    }

    @Override
    protected void registerGraphBuilderInvocationPlugins(InvocationPlugins invocationPlugins, boolean canDelayIntrinsification) {
        super.registerGraphBuilderInvocationPlugins(invocationPlugins, canDelayIntrinsification);
        HotSpotTruffleGraphBuilderPlugins.registerCompilationFinalReferencePlugins(invocationPlugins, canDelayIntrinsification, (HotSpotKnownTruffleTypes)this.getTypes());
    }

    @Override
    public EconomicMap<ResolvedJavaMethod, EncodedGraph> getOrCreateEncodedGraphCache() {
        EconomicMap cache;
        if (!this.persistentEncodedGraphCache) {
            return super.getOrCreateEncodedGraphCache();
        }
        while ((cache = this.graphCacheRef.get()) == null && !this.graphCacheRef.compareAndSet(null, (EconomicMap<ResolvedJavaMethod, EncodedGraph>)(cache = EconomicMap.wrapMap(new ConcurrentHashMap())))) {
        }
        assert (cache != null);
        return cache;
    }

    public void purgeEncodedGraphCache() {
        if (!this.disableEncodedGraphCachePurges) {
            this.graphCacheRef.set(null);
        }
    }

    public boolean disableEncodedGraphCachePurges(boolean value) {
        boolean oldValue = this.disableEncodedGraphCachePurges;
        this.disableEncodedGraphCachePurges = value;
        return oldValue;
    }

    public boolean persistentEncodedGraphCache(boolean value) {
        boolean oldValue = this.persistentEncodedGraphCache;
        this.persistentEncodedGraphCache = value;
        return oldValue;
    }

    @Override
    protected Supplier<AutoCloseable> getCreateCachedGraphScope() {
        if (this.persistentEncodedGraphCache) {
            return HotSpotGraalServices::enterGlobalCompilationContext;
        }
        return super.getCreateCachedGraphScope();
    }

    final class PartialEvaluationMethodInfoCache
    extends TruffleElementCache<ResolvedJavaMethod, PartialEvaluationMethodInfo> {
        PartialEvaluationMethodInfoCache() {
            super(1024);
        }

        @Override
        protected Object createKey(ResolvedJavaMethod method) {
            return new MethodKey(method);
        }

        @Override
        protected PartialEvaluationMethodInfo computeValue(ResolvedJavaMethod method) {
            PartialEvaluationMethodInfo methodInfo = HotSpotPartialEvaluator.this.config.runtime().getPartialEvaluationMethodInfo(method);
            return HotSpotPartialEvaluator.this.canonicalMethodInfos.computeIfAbsent(methodInfo, k -> k);
        }
    }

    final class ConstantFieldInfoCache
    extends TruffleElementCache<ResolvedJavaField, ConstantFieldInfo> {
        ConstantFieldInfoCache() {
            super(1024);
        }

        @Override
        protected Object createKey(ResolvedJavaField field) {
            return new FieldKey(field);
        }

        @Override
        protected ConstantFieldInfo computeValue(ResolvedJavaField field) {
            return HotSpotPartialEvaluator.this.config.runtime().getConstantFieldInfo(field);
        }
    }
}

