/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.hotspot;

import java.lang.ref.Reference;
import java.lang.reflect.Type;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.nodes.HotSpotLoadReservedReferenceNode;
import jdk.graal.compiler.hotspot.nodes.HotSpotStoreReservedReferenceNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.truffle.hotspot.HotSpotKnownTruffleTypes;
import jdk.graal.compiler.word.WordTypes;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;

final class HotSpotTruffleGraphBuilderPlugins {
    HotSpotTruffleGraphBuilderPlugins() {
    }

    static void registerCompilationFinalReferencePlugins(InvocationPlugins plugins, final boolean canDelayIntrinsification, final HotSpotKnownTruffleTypes types) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Reference.class));
        r.register(new InvocationPlugin.RequiredInvocationPlugin("get", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                JavaConstant constant;
                if (!canDelayIntrinsification && receiver.isConstant() && (constant = (JavaConstant)receiver.get().asConstant()).isNonNull() && (types.WeakReference.isInstance(constant) || types.SoftReference.isInstance(constant))) {
                    JavaConstant referent = b.getConstantReflection().readFieldValue(types.Reference_referent, constant);
                    b.addPush(JavaKind.Object, ConstantNode.forConstant(referent, b.getMetaAccess()));
                    return true;
                }
                return false;
            }
        });
    }

    static void registerHotspotThreadLocalStubPlugins(InvocationPlugins plugins, final WordTypes wordTypes, final int jvmciReservedReference0Offset) {
        GraalError.guarantee(jvmciReservedReference0Offset != -1, "jvmciReservedReference0Offset is not available but used.");
        InvocationPlugins.Registration tl = new InvocationPlugins.Registration(plugins, "com.oracle.truffle.runtime.hotspot.HotSpotFastThreadLocal");
        tl.register(new InvocationPlugin.RequiredInvocationPlugin("getJVMCIReservedReference", new Type[0]){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Object, new HotSpotLoadReservedReferenceNode(b.getMetaAccess(), wordTypes, jvmciReservedReference0Offset));
                return true;
            }
        });
        tl.register(new InvocationPlugin.RequiredInvocationPlugin("setJVMCIReservedReference", new Type[]{Object[].class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.add(new HotSpotStoreReservedReferenceNode(wordTypes, value, jvmciReservedReference0Offset));
                return true;
            }
        });
    }
}

