/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.hotspot.aarch64;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.aarch64.AArch64Address;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotGraalRuntime;
import jdk.graal.compiler.hotspot.aarch64.AArch64HotSpotBackend;
import jdk.graal.compiler.hotspot.aarch64.AArch64HotSpotMove;
import jdk.graal.compiler.hotspot.aarch64.AArch64HotSpotZBarrierSetLIRGenerator;
import jdk.graal.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotRegistersProvider;
import jdk.graal.compiler.lir.aarch64.AArch64FrameMap;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.asm.EntryPointDecorator;
import jdk.graal.compiler.serviceprovider.ServiceProvider;
import jdk.graal.compiler.truffle.TruffleCompilerConfiguration;
import jdk.graal.compiler.truffle.hotspot.TruffleCallBoundaryInstrumentationFactory;
import jdk.graal.compiler.truffle.hotspot.TruffleEntryPointDecorator;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.meta.JavaKind;

@ServiceProvider(value=TruffleCallBoundaryInstrumentationFactory.class)
public class AArch64TruffleCallBoundaryInstrumentationFactory
extends TruffleCallBoundaryInstrumentationFactory {
    @Override
    public EntryPointDecorator create(TruffleCompilerConfiguration compilerConfig, GraalHotSpotVMConfig config, HotSpotRegistersProvider registers) {
        return new TruffleEntryPointDecorator(this, compilerConfig, config, registers){

            @Override
            public void emitEntryPoint(CompilationResultBuilder crb) {
                AArch64MacroAssembler masm = (AArch64MacroAssembler)crb.asm;
                AArch64HotSpotBackend.emitInvalidatePlaceholder(crb, masm);
                try (AArch64MacroAssembler.ScratchRegister scratch = masm.getScratchRegister();){
                    Register thisRegister = crb.getCodeCache().getRegisterConfig().getCallingConventionRegisters((CallingConvention.Type)HotSpotCallingConventionType.JavaCall, JavaKind.Object).get(0);
                    Register spillRegister = scratch.getRegister();
                    Label doProlog = new Label();
                    if (this.config.useCompressedOops) {
                        CompressEncoding encoding = this.config.getOopEncoding();
                        masm.ldr(32, spillRegister, AArch64Address.createImmediateAddress(32, AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, thisRegister, this.installedCodeOffset));
                        Register base = encoding.hasBase() ? this.registers.getHeapBaseRegister() : null;
                        AArch64HotSpotMove.UncompressPointer.emitUncompressCode(masm, spillRegister, spillRegister, base, encoding.getShift(), true);
                    } else {
                        AArch64Address address = AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, thisRegister, this.installedCodeOffset);
                        masm.ldr(64, spillRegister, address);
                        if (this.config.gc == HotSpotGraalRuntime.HotSpotGC.Z) {
                            ForeignCallLinkage callTarget = crb.getForeignCalls().lookupForeignCall(HotSpotHostForeignCallsProvider.Z_FIELD_BARRIER);
                            AArch64FrameMap frameMap = (AArch64FrameMap)crb.frameMap;
                            AArch64HotSpotZBarrierSetLIRGenerator.emitBarrier(crb, masm, null, spillRegister, this.config, callTarget, address, null, frameMap);
                        }
                    }
                    masm.ldr(64, spillRegister, AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, spillRegister, this.entryPointOffset));
                    masm.cbz(64, spillRegister, doProlog);
                    masm.jmp(spillRegister);
                    masm.nop();
                    masm.bind(doProlog);
                }
            }
        };
    }

    @Override
    public String getArchitecture() {
        return "aarch64";
    }
}

