/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.nodes.frame;

import jdk.graal.compiler.graph.IterableNodeType;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.Virtualizable;
import jdk.graal.compiler.nodes.spi.VirtualizerTool;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;

@NodeInfo(nameTemplate="AllowMaterialize{p#frame/s}", cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class AllowMaterializeNode
extends FixedWithNextNode
implements IterableNodeType,
Virtualizable {
    public static final NodeClass<AllowMaterializeNode> TYPE = NodeClass.create(AllowMaterializeNode.class);
    @Node.Input
    ValueNode frame;

    public AllowMaterializeNode(ValueNode frame) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, frame.stamp(NodeView.DEFAULT));
        this.frame = frame;
    }

    public ValueNode getFrame() {
        return this.frame;
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode alias = tool.getAlias(this.frame);
        if (alias instanceof VirtualObjectNode) {
            VirtualObjectNode virtual = (VirtualObjectNode)alias;
            tool.setEnsureVirtualized(virtual, false);
            tool.replaceWithVirtual(virtual);
        } else {
            tool.replaceWithValue(alias);
        }
    }
}

