/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.nodes.frame;

public enum VirtualFrameAccessFlags {
    BENIGN(0),
    NON_STATIC(14),
    STATIC_PRIMITIVE(11),
    STATIC_OBJECT(13),
    STATIC_BOTH(15),
    NON_STATIC_UPDATE(30),
    STATIC_PRIMITIVE_UPDATE(27),
    STATIC_OBJECT_UPDATE(29),
    STATIC_BOTH_UPDATE(31),
    NON_STATIC_NO_SET_TAG_UPDATE(22);

    private final byte flags;

    private VirtualFrameAccessFlags(byte flags) {
        this.flags = flags;
    }

    public final boolean isStatic() {
        return (this.flags & 1) != 0;
    }

    public final boolean isPrimitive() {
        return (this.flags & 2) != 0;
    }

    public final boolean isObject() {
        return (this.flags & 4) != 0;
    }

    public final boolean setsTag() {
        return (this.flags & 8) != 0;
    }

    public final boolean updatesFrame() {
        return (this.flags & 0x10) != 0;
    }

    private static final class Constants {
        static final byte STATIC_FLAG = 1;
        static final byte PRIMITIVE_FLAG = 2;
        static final byte OBJECT_FLAG = 4;
        static final byte SET_TAG_FLAG = 8;
        static final byte UPDATES_FRAME = 16;
        public static final byte BENIGN = 0;
        public static final byte NON_STATIC = 14;
        public static final byte NON_STATIC_UPDATE = 30;
        public static final byte NON_STATIC_UPDATE_NO_SET_TAG = 22;
        public static final byte STATIC = 15;
        public static final byte STATIC_PRIMITIVE = 11;
        public static final byte STATIC_OBJECT = 13;
        public static final byte STATIC_UPDATE = 31;
        public static final byte STATIC_PRIMITIVE_UPDATE = 27;
        public static final byte STATIC_OBJECT_UPDATE = 29;

        private Constants() {
        }
    }
}

