/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.phases;

import java.util.function.Predicate;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.phases.Phase;
import jdk.graal.compiler.truffle.nodes.SpeculativeExceptionAnchorNode;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class DeoptimizeOnExceptionPhase
extends Phase {
    private final Predicate<ResolvedJavaMethod> deoptimizeOnExceptionPredicate;

    public DeoptimizeOnExceptionPhase(Predicate<ResolvedJavaMethod> deoptimizeOnExceptionPredicate) {
        this.deoptimizeOnExceptionPredicate = deoptimizeOnExceptionPredicate;
    }

    @Override
    protected void run(StructuredGraph graph) {
        for (Invoke invoke : graph.getInvokes()) {
            InvokeWithExceptionNode invokeWithException;
            ResolvedJavaMethod targetMethod;
            if (!(invoke instanceof InvokeWithExceptionNode) || !this.deoptimizeOnExceptionPredicate.test(targetMethod = (invokeWithException = (InvokeWithExceptionNode)invoke).callTarget().targetMethod())) continue;
            AbstractBeginNode exceptionEdge = invokeWithException.exceptionEdge();
            FixedWithNextNode newNode = graph.add(new SpeculativeExceptionAnchorNode(DeoptimizationReason.TransferToInterpreter, DeoptimizationAction.InvalidateRecompile, targetMethod));
            graph.addAfterFixed(exceptionEdge, newNode);
        }
    }
}

