/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.phases;

import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.debug.MethodFilter;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.truffle.TruffleTierContext;
import jdk.graal.compiler.truffle.phases.InstrumentPhase;
import jdk.vm.ci.meta.JavaConstant;

public class InstrumentBranchesPhase
extends InstrumentPhase {
    private final boolean isInstrumentPerInlineSite;

    public InstrumentBranchesPhase(SnippetReflectionProvider snippetReflection, InstrumentPhase.Instrumentation instrumentation, boolean instrumentPerInlineSite) {
        super(snippetReflection, instrumentation);
        this.isInstrumentPerInlineSite = instrumentPerInlineSite;
    }

    @Override
    protected void instrumentGraph(StructuredGraph graph, TruffleTierContext context, JavaConstant tableConstant) {
        MethodFilter methodFilter = this.methodFilter(context);
        for (IfNode n : graph.getNodes(IfNode.TYPE)) {
            InstrumentPhase.Point p = this.getOrCreatePoint(n, methodFilter);
            if (p == null) continue;
            InstrumentBranchesPhase.insertCounter(graph, context, tableConstant, n.trueSuccessor(), p.slotIndex(0));
            InstrumentBranchesPhase.insertCounter(graph, context, tableConstant, n.falseSuccessor(), p.slotIndex(1));
        }
    }

    @Override
    protected int instrumentationPointSlotCount() {
        return 2;
    }

    @Override
    protected boolean instrumentPerInlineSite() {
        return this.isInstrumentPerInlineSite;
    }

    @Override
    protected InstrumentPhase.Point createPoint(int id, int startIndex, Node n) {
        return new IfPoint(id, startIndex, n.getNodeSourcePosition());
    }

    public class IfPoint
    extends InstrumentPhase.Point {
        IfPoint(int id, int rawIndex, NodeSourcePosition position) {
            super(id, rawIndex, position);
        }

        @Override
        public int slotCount() {
            return 2;
        }

        @Override
        public boolean isPrettified() {
            return InstrumentBranchesPhase.this.isInstrumentPerInlineSite;
        }

        public long ifVisits() {
            return InstrumentBranchesPhase.this.getInstrumentation().getAccessTable()[this.rawIndex];
        }

        public long elseVisits() {
            return InstrumentBranchesPhase.this.getInstrumentation().getAccessTable()[this.rawIndex + 1];
        }

        public BranchState getBranchState() {
            return BranchState.from(this.ifVisits() > 0L, this.elseVisits() > 0L);
        }

        public String getCounts() {
            return "if=" + this.ifVisits() + "#, else=" + this.elseVisits() + "#";
        }

        @Override
        public long getHotness() {
            return this.ifVisits() + this.elseVisits();
        }

        public String toString() {
            return "[" + this.id + "] state = " + String.valueOf((Object)this.getBranchState()) + "(" + this.getCounts() + ")";
        }
    }

    public static enum BranchState {
        NONE,
        IF,
        ELSE,
        BOTH;


        public static BranchState from(boolean ifVisited, boolean elseVisited) {
            if (ifVisited && elseVisited) {
                return BOTH;
            }
            if (ifVisited && !elseVisited) {
                return IF;
            }
            if (!ifVisited && elseVisited) {
                return ELSE;
            }
            return NONE;
        }
    }
}

