/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.phases;

import com.oracle.truffle.compiler.TruffleCompilerRuntime;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.debug.MethodFilter;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.truffle.TruffleTierContext;
import jdk.graal.compiler.truffle.phases.InstrumentPhase;
import jdk.vm.ci.meta.JavaConstant;

public class InstrumentTruffleBoundariesPhase
extends InstrumentPhase {
    private final boolean isInstrumentPerInlineSite;

    public InstrumentTruffleBoundariesPhase(SnippetReflectionProvider snippetReflection, InstrumentPhase.Instrumentation instrumentation, boolean instrumentPerInlineSite) {
        super(snippetReflection, instrumentation);
        this.isInstrumentPerInlineSite = instrumentPerInlineSite;
    }

    @Override
    protected void instrumentGraph(StructuredGraph graph, TruffleTierContext context, JavaConstant tableConstant) {
        MethodFilter methodFilter = this.methodFilter(context);
        for (Node n : graph.getNodes()) {
            InstrumentPhase.Point p;
            if (!(n instanceof Invoke)) continue;
            Invoke invoke = (Invoke)((Object)n);
            if (context.getPartialEvaluator().getMethodInfo(invoke.callTarget().targetMethod()).inlineForPartialEvaluation() == TruffleCompilerRuntime.InlineKind.INLINE || (p = this.getOrCreatePoint(n, methodFilter)) == null) continue;
            InstrumentTruffleBoundariesPhase.insertCounter(graph, context, tableConstant, (FixedWithNextNode)n.predecessor(), p.slotIndex(0));
        }
    }

    @Override
    protected int instrumentationPointSlotCount() {
        return 1;
    }

    @Override
    protected boolean instrumentPerInlineSite() {
        return this.isInstrumentPerInlineSite;
    }

    @Override
    protected InstrumentPhase.Point createPoint(int id, int startIndex, Node n) {
        return new BoundaryPoint(id, startIndex, n.getNodeSourcePosition());
    }

    public class BoundaryPoint
    extends InstrumentPhase.Point {
        BoundaryPoint(int id, int rawIndex, NodeSourcePosition position) {
            super(id, rawIndex, position);
        }

        @Override
        public int slotCount() {
            return 1;
        }

        @Override
        public boolean isPrettified() {
            return InstrumentTruffleBoundariesPhase.this.isInstrumentPerInlineSite;
        }

        @Override
        public long getHotness() {
            return InstrumentTruffleBoundariesPhase.this.getInstrumentation().getAccessTable()[this.rawIndex];
        }

        public String toString() {
            return "[" + this.id + "] count = " + this.getHotness();
        }
    }
}

