/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.phases;

import jdk.graal.compiler.core.phases.BaseTier;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.truffle.PartialEvaluator;
import jdk.graal.compiler.truffle.PostPartialEvaluationSuite;
import jdk.graal.compiler.truffle.TruffleCompilerOptions;
import jdk.graal.compiler.truffle.TruffleTierContext;
import jdk.graal.compiler.truffle.phases.InliningAcrossTruffleBoundaryPhase;
import jdk.graal.compiler.truffle.phases.InstrumentationSuite;
import jdk.graal.compiler.truffle.phases.MaterializeFramesPhase;
import jdk.graal.compiler.truffle.phases.NeverPartOfCompilationPhase;
import jdk.graal.compiler.truffle.phases.ReportPerformanceWarningsPhase;
import jdk.graal.compiler.truffle.phases.SetIdentityForValueTypesPhase;
import jdk.graal.compiler.truffle.phases.VerifyFrameDoesNotEscapePhase;
import jdk.graal.compiler.truffle.phases.inlining.AgnosticInliningPhase;

public class TruffleTier
extends BaseTier<TruffleTierContext> {
    public TruffleTier(OptionValues options, PartialEvaluator partialEvaluator, InstrumentationSuite instrumentationSuite, PostPartialEvaluationSuite postPartialEvaluationSuite) {
        this.appendPhase(new AgnosticInliningPhase(partialEvaluator, postPartialEvaluationSuite));
        this.appendPhase(instrumentationSuite);
        this.appendPhase(new ReportPerformanceWarningsPhase());
        this.appendPhase(new VerifyFrameDoesNotEscapePhase());
        this.appendPhase(new NeverPartOfCompilationPhase());
        this.appendPhase(new MaterializeFramesPhase());
        this.appendPhase(new SetIdentityForValueTypesPhase());
        if (!TruffleCompilerOptions.InlineAcrossTruffleBoundary.getValue(options).booleanValue()) {
            this.appendPhase(new InliningAcrossTruffleBoundaryPhase());
        }
    }
}

