/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.phases;

import jdk.graal.compiler.graph.GraalGraphError;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.truffle.TruffleTierContext;
import jdk.graal.compiler.truffle.nodes.frame.NewFrameNode;

public class VerifyFrameDoesNotEscapePhase
extends BasePhase<TruffleTierContext> {
    @Override
    protected void run(StructuredGraph graph, TruffleTierContext context) {
        graph.checkCancellation();
        for (NewFrameNode virtualFrame : graph.getNodes(NewFrameNode.TYPE)) {
            for (MethodCallTargetNode callTarget : virtualFrame.usages().filter(MethodCallTargetNode.class)) {
                if (callTarget.invoke() == null) continue;
                String properties = callTarget.getDebugProperties().toString();
                String arguments = callTarget.arguments().toString();
                GraalGraphError exception = new GraalGraphError("Frame escapes at: %s#%s\nproperties:%s\narguments: %s", callTarget, callTarget.targetMethod(), properties, arguments);
                throw GraphUtil.approxSourceException(callTarget, exception);
            }
        }
    }
}

