/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class TypedDataInputStream
extends DataInputStream {
    public TypedDataInputStream(InputStream in) {
        super(in);
    }

    public Object readTypedValue() throws IOException {
        byte type = this.readByte();
        return switch (type) {
            case 90 -> this.readBoolean();
            case 66 -> this.readByte();
            case 83 -> this.readShort();
            case 67 -> Character.valueOf(this.readChar());
            case 73 -> this.readInt();
            case 74 -> this.readLong();
            case 70 -> Float.valueOf(this.readFloat());
            case 68 -> this.readDouble();
            case 85 -> {
                int len = this.readInt();
                byte[] bytes = new byte[len];
                this.readFully(bytes);
                yield new String(bytes, StandardCharsets.UTF_8);
            }
            default -> throw new IOException("Unsupported type: " + Integer.toHexString(type));
        };
    }
}

