/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.virtual.phases.ea;

import java.util.Optional;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.virtual.phases.ea.PartialEscapePhase;
import jdk.graal.compiler.virtual.phases.ea.VirtualUtil;

public class FinalPartialEscapePhase
extends PartialEscapePhase {
    public FinalPartialEscapePhase(boolean iterative, CanonicalizerPhase canonicalizer, BasePhase<CoreProviders> cleanupPhase, OptionValues options) {
        super(iterative, PartialEscapePhase.Options.OptEarlyReadElimination.getValue(options), canonicalizer, cleanupPhase, options);
    }

    public FinalPartialEscapePhase(int iterations, CanonicalizerPhase canonicalizer, BasePhase<CoreProviders> cleanupPhase, OptionValues options) {
        super(iterations, PartialEscapePhase.Options.OptEarlyReadElimination.getValue(options), canonicalizer, cleanupPhase);
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(super.notApplicableTo(graphState), BasePhase.NotApplicable.ifApplied(this, GraphState.StageFlag.FINAL_PARTIAL_ESCAPE, graphState));
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        if (VirtualUtil.matches(graph, GraalOptions.EscapeAnalyzeOnly.getValue(graph.getOptions()))) {
            graph.getGraphState().setDuringStage(GraphState.StageFlag.FINAL_PARTIAL_ESCAPE);
            super.run(graph, context);
        }
    }

    @Override
    public void updateGraphState(GraphState graphState) {
        super.updateGraphState(graphState);
        graphState.setAfterStage(GraphState.StageFlag.FINAL_PARTIAL_ESCAPE);
    }
}

