/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.virtual.phases.ea;

import java.util.ArrayList;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.ControlSinkNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.memory.MemoryKill;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.nodes.virtual.EscapeObjectState;
import jdk.graal.compiler.nodes.virtual.VirtualObjectState;
import jdk.graal.compiler.virtual.phases.ea.EffectList;

public final class GraphEffectList
extends EffectList {
    private int virtualizationDelta;
    private int allocationNodeDelta;

    public GraphEffectList(DebugContext debug) {
        super(debug);
    }

    @Override
    public void clear() {
        super.clear();
        this.virtualizationDelta = 0;
        this.allocationNodeDelta = 0;
    }

    public void addFixedNodeBefore(final FixedWithNextNode node, final FixedNode position) {
        this.add(new EffectList.SimpleEffect(this, "add fixed node"){

            @Override
            public void apply(StructuredGraph graph) {
                assert (!node.isAlive() && !node.isDeleted() && position.isAlive()) : Assertions.errorMessageContext("node", node, "position", position);
                graph.addBeforeFixed(position, graph.add(node));
            }

            @Override
            void format(StringBuilder str) {
                this.format(str, new String[]{"node", "position"}, new Object[]{node, position});
            }
        });
    }

    void ensureAdded(final ValueNode node, final FixedNode position) {
        assert (!(node instanceof FixedWithNextNode) || position != null);
        this.add(new EffectList.SimpleEffect(this, "ensure added"){

            @Override
            public void apply(StructuredGraph graph) {
                assert (position == null || position.isAlive());
                if (!node.isAlive()) {
                    graph.addWithoutUniqueWithInputs(node);
                    if (node instanceof FixedWithNextNode) {
                        graph.addBeforeFixed(position, (FixedWithNextNode)node);
                    }
                }
            }

            @Override
            void format(StringBuilder str) {
                this.format(str, new String[]{"node", "position"}, new Object[]{node, position});
            }
        });
    }

    public void addVirtualizationDelta(int delta) {
        this.virtualizationDelta += delta;
    }

    public int getVirtualizationDelta() {
        return this.virtualizationDelta;
    }

    public void addAllocationDelta(int delta) {
        this.allocationNodeDelta += delta;
    }

    public int getAllocationDelta() {
        return this.allocationNodeDelta;
    }

    public void addFloatingNode(final ValueNode node, final String cause) {
        this.add(new EffectList.SimpleEffect(this, "add floating node"){

            @Override
            public void apply(StructuredGraph graph) {
                GraalError.guarantee(node.isUnregistered(), cause);
                assert (!node.isAlive() && !node.isDeleted()) : node;
                graph.addWithoutUniqueWithInputs(node);
            }

            @Override
            void format(StringBuilder str) {
                this.format(str, new String[]{"node", "cause"}, new Object[]{node, cause});
            }
        });
    }

    void ensureFloatingAdded(ValueNode node) {
        this.ensureAdded(node, null);
    }

    public void initializePhiInput(final PhiNode node, final int index, final ValueNode value) {
        this.add(new EffectList.Effect(this, "set phi input"){

            @Override
            public void apply(StructuredGraph graph, ArrayList<Node> obsoleteNodes) {
                assert (node.isAlive() && index >= 0) : node;
                node.initializeValueAt(index, graph.addOrUniqueWithInputs(value));
            }

            @Override
            void format(StringBuilder str) {
                this.format(str, new String[]{"node", "index", "value"}, new Object[]{node, index, value});
            }
        });
    }

    public void addVirtualMapping(final FrameState node, final EscapeObjectState state) {
        this.add(new EffectList.Effect(this, "add virtual mapping"){

            @Override
            public void apply(StructuredGraph graph, ArrayList<Node> obsoleteNodes) {
                if (node.isAlive()) {
                    assert (!state.isDeleted());
                    FrameState stateAfter = node;
                    for (int i = 0; i < stateAfter.virtualObjectMappingCount(); ++i) {
                        if (stateAfter.virtualObjectMappingAt(i).object() != state.object()) continue;
                        stateAfter.virtualObjectMappings().remove(i);
                    }
                    stateAfter.addVirtualObjectMapping(graph.addOrUniqueWithInputs(state));
                }
            }

            @Override
            public boolean isVisible() {
                return false;
            }

            @Override
            void format(StringBuilder str) {
                this.format(str, new String[]{"node", "state"}, new Object[]{node, state});
            }
        });
    }

    public void updateVirtualMapping(final VirtualObjectState state, final int field, final ValueNode newValue) {
        this.add(new EffectList.Effect(this, "add virtual mapping"){

            @Override
            public void apply(StructuredGraph graph, ArrayList<Node> obsoleteNodes) {
                if (state.isAlive()) {
                    state.values().set(field, (Object)graph.addOrUniqueWithInputs(newValue));
                }
            }

            @Override
            public boolean isVisible() {
                return false;
            }

            @Override
            void format(StringBuilder str) {
                this.format(str, new String[]{"state", "field", "newValue"}, new Object[]{state, field, newValue});
            }
        });
    }

    public void deleteNode(final Node node) {
        this.add(new EffectList.Effect(this, "delete fixed node"){

            @Override
            public void apply(StructuredGraph graph, ArrayList<Node> obsoleteNodes) {
                if (node instanceof FixedWithNextNode) {
                    GraphUtil.unlinkFixedNode((FixedWithNextNode)node);
                } else if (node instanceof WithExceptionNode && node.isAlive()) {
                    WithExceptionNode withExceptionNode = (WithExceptionNode)node;
                    AbstractBeginNode next = withExceptionNode.next();
                    GraphUtil.unlinkAndKillExceptionEdge(withExceptionNode);
                    if (next.hasNoUsages() && MemoryKill.isMemoryKill(next)) {
                        graph.replaceFixedWithFixed(next, graph.add(new BeginNode()));
                    }
                    obsoleteNodes.add(withExceptionNode);
                }
                obsoleteNodes.add(node);
            }

            @Override
            public boolean isCfgKill() {
                return node instanceof WithExceptionNode;
            }

            @Override
            void format(StringBuilder str) {
                this.format(str, new String[]{"node"}, new Object[]{node});
            }
        });
    }

    public void killIfBranch(final IfNode ifNode, final boolean constantCondition) {
        this.add(new EffectList.Effect(this, "kill if branch"){

            @Override
            public void apply(StructuredGraph graph, ArrayList<Node> obsoleteNodes) {
                if (ifNode.isAlive()) {
                    graph.removeSplitPropagate(ifNode, ifNode.getSuccessor(constantCondition));
                }
            }

            @Override
            public boolean isCfgKill() {
                return true;
            }

            @Override
            void format(StringBuilder str) {
                this.format(str, new String[]{"ifNode", "constantCondition"}, new Object[]{ifNode, constantCondition});
            }
        });
    }

    public void replaceWithSink(final FixedWithNextNode node, final ControlSinkNode sink) {
        this.add(new EffectList.Effect(this, "replace with sink"){

            @Override
            public void apply(StructuredGraph graph, ArrayList<Node> obsoleteNodes) {
                try (DebugCloseable position = graph.withNodeSourcePosition(node);){
                    graph.addWithoutUnique(sink);
                    node.replaceAtPredecessor(sink);
                    GraphUtil.killCFG(node);
                }
            }

            @Override
            public boolean isCfgKill() {
                return true;
            }

            @Override
            void format(StringBuilder str) {
                this.format(str, new String[]{"node", "sink"}, new Object[]{node, sink});
            }
        });
    }

    public void replaceAtUsages(final ValueNode node, final ValueNode replacement, final FixedNode insertBefore) {
        assert (node != null && replacement != null) : String.valueOf(node) + " " + String.valueOf(replacement);
        assert (!node.hasUsages() || node.stamp(NodeView.DEFAULT).isCompatible(replacement.stamp(NodeView.DEFAULT))) : "Replacement node stamp not compatible " + String.valueOf(node.stamp(NodeView.DEFAULT)) + " vs " + String.valueOf(replacement.stamp(NodeView.DEFAULT));
        this.add(new EffectList.Effect(this, "replace at usages"){

            @Override
            public void apply(StructuredGraph graph, ArrayList<Node> obsoleteNodes) {
                try (DebugCloseable position = graph.withNodeSourcePosition(node);){
                    assert (node.isAlive());
                    ValueNode replacementNode = graph.addOrUniqueWithInputs(replacement);
                    assert (replacementNode.isAlive());
                    assert (insertBefore != null);
                    if (replacementNode instanceof FixedWithNextNode && ((FixedWithNextNode)replacementNode).next() == null) {
                        graph.addBeforeFixed(insertBefore, (FixedWithNextNode)replacementNode);
                    }
                    if (node.hasUsages() && replacementNode.stamp(NodeView.DEFAULT).tryImproveWith(node.stamp(NodeView.DEFAULT)) != null) {
                        replacementNode = graph.unique(new PiNode(replacementNode, node.stamp(NodeView.DEFAULT)));
                    }
                    node.replaceAtUsages(replacementNode);
                    if (node instanceof WithExceptionNode) {
                        GraphUtil.unlinkAndKillExceptionEdge((WithExceptionNode)node);
                    } else if (node instanceof FixedWithNextNode) {
                        GraphUtil.unlinkFixedNode((FixedWithNextNode)node);
                    }
                    obsoleteNodes.add(node);
                }
            }

            @Override
            void format(StringBuilder str) {
                this.format(str, new String[]{"node", "replacement", "insertBefore"}, new Object[]{node, replacement, insertBefore});
            }
        });
    }

    public void replaceFirstInput(final Node node, final Node oldInput, final Node newInput) {
        assert (node.isAlive() && oldInput.isAlive() && !newInput.isDeleted()) : Assertions.errorMessageContext("node", node, "newInput", newInput);
        this.add(new EffectList.Effect(this, "replace first input"){

            @Override
            public void apply(StructuredGraph graph, ArrayList<Node> obsoleteNodes) {
                if (node.isAlive()) {
                    assert (oldInput.isAlive() && newInput.isAlive()) : "Both must be alive " + Assertions.errorMessageContext("oldInput", oldInput, "newInput", newInput);
                    node.replaceFirstInput(oldInput, newInput);
                }
            }

            @Override
            public boolean isVisible() {
                return !(node instanceof FrameState);
            }

            @Override
            void format(StringBuilder str) {
                this.format(str, new String[]{"node", "oldInput", "newInput"}, new Object[]{node, oldInput, newInput});
            }
        });
    }
}

