/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.virtual.phases.ea;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.java.MonitorIdNode;
import jdk.graal.compiler.nodes.virtual.AllocatedObjectNode;
import jdk.graal.compiler.nodes.virtual.CommitAllocationNode;
import jdk.graal.compiler.nodes.virtual.LockState;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.virtual.phases.ea.EffectList;
import jdk.graal.compiler.virtual.phases.ea.EffectsBlockState;
import jdk.graal.compiler.virtual.phases.ea.GraphEffectList;
import jdk.graal.compiler.virtual.phases.ea.ObjectState;
import jdk.graal.compiler.virtual.phases.ea.PartialEscapeClosure;
import jdk.graal.compiler.virtual.phases.ea.VirtualUtil;

public abstract class PartialEscapeBlockState<T extends PartialEscapeBlockState<T>>
extends EffectsBlockState<T> {
    private static final ObjectState[] EMPTY_ARRAY = new ObjectState[0];
    private ObjectState[] objectStates;
    private RefCount arrayRefCount;
    private final OptionValues options;
    private final DebugContext debug;

    public boolean contains(VirtualObjectNode value) {
        for (ObjectState state : this.objectStates) {
            if (state == null || !state.isVirtual() || state.getEntries() == null) continue;
            for (ValueNode entry : state.getEntries()) {
                if (entry != value) continue;
                return true;
            }
        }
        return false;
    }

    protected PartialEscapeBlockState(OptionValues options, DebugContext debug) {
        this.objectStates = EMPTY_ARRAY;
        this.arrayRefCount = new RefCount();
        this.options = options;
        this.debug = debug;
    }

    protected PartialEscapeBlockState(PartialEscapeBlockState<T> other) {
        super(other);
        this.adoptAddObjectStates(other);
        this.options = other.options;
        this.debug = other.debug;
    }

    public ObjectState getObjectState(int object) {
        ObjectState state = this.objectStates[object];
        assert (state != null);
        return state;
    }

    public ObjectState getObjectStateOptional(int object) {
        return object >= this.objectStates.length ? null : this.objectStates[object];
    }

    public boolean hasObjectState(int object) {
        return object >= 0 && object < this.objectStates.length && this.objectStates[object] != null;
    }

    public ObjectState getObjectState(VirtualObjectNode object) {
        ObjectState state = this.objectStates[object.getObjectId()];
        assert (state != null);
        return state;
    }

    public ObjectState getObjectStateOptional(VirtualObjectNode object) {
        int id = object.getObjectId();
        return id >= this.objectStates.length ? null : this.objectStates[id];
    }

    private ObjectState[] getObjectStateArrayForModification() {
        if (this.arrayRefCount.refCount > 1) {
            this.objectStates = (ObjectState[])this.objectStates.clone();
            --this.arrayRefCount.refCount;
            this.arrayRefCount = new RefCount();
        }
        return this.objectStates;
    }

    private ObjectState getObjectStateForModification(int object) {
        ObjectState[] array = this.getObjectStateArrayForModification();
        ObjectState objectState = array[object];
        if (objectState.copyOnWrite) {
            array[object] = objectState = objectState.cloneState();
        }
        return objectState;
    }

    public void setEntry(int object, int entryIndex, ValueNode value) {
        if (this.objectStates[object].getEntry(entryIndex) != value) {
            this.getObjectStateForModification(object).setEntry(entryIndex, value);
        }
    }

    public void escape(int object, ValueNode materialized) {
        this.getObjectStateForModification(object).escape(materialized);
    }

    public void addLock(int object, MonitorIdNode monitorId) {
        this.getObjectStateForModification(object).addLock(monitorId);
    }

    public MonitorIdNode removeLock(int object) {
        return this.getObjectStateForModification(object).removeLock();
    }

    public void setEnsureVirtualized(int object, boolean ensureVirtualized) {
        if (this.objectStates[object].getEnsureVirtualized() != ensureVirtualized) {
            this.getObjectStateForModification(object).setEnsureVirtualized(ensureVirtualized);
        }
    }

    public void updateMaterializedValue(int object, ValueNode value) {
        if (this.objectStates[object].getMaterializedValue() != value) {
            this.getObjectStateForModification(object).updateMaterializedValue(value);
        }
    }

    public void materializeBefore(final FixedNode fixed, final VirtualObjectNode virtual, final GraphEffectList materializeEffects) {
        PartialEscapeClosure.COUNTER_MATERIALIZATIONS.increment(fixed.getDebug());
        final ArrayList<AllocatedObjectNode> objects = new ArrayList<AllocatedObjectNode>(2);
        final ArrayList<ValueNode> values = new ArrayList<ValueNode>(8);
        final ArrayList<List<MonitorIdNode>> locks = new ArrayList<List<MonitorIdNode>>();
        final ArrayList<ValueNode> otherAllocations = new ArrayList<ValueNode>(2);
        final ArrayList<Boolean> ensureVirtual = new ArrayList<Boolean>(2);
        this.materializeWithCommit(fixed, virtual, objects, locks, values, ensureVirtual, otherAllocations, materializeEffects);
        materializeEffects.addAllocationDelta(objects.size() > 0 ? -1 : 0);
        materializeEffects.addVirtualizationDelta(-(objects.size() + otherAllocations.size()));
        materializeEffects.add(new EffectList.Effect(this, "materializeBefore"){

            @Override
            public void apply(StructuredGraph graph, ArrayList<Node> obsoleteNodes) {
                for (ValueNode alloc : otherAllocations) {
                    ValueNode otherAllocation = graph.addOrUniqueWithInputs(alloc);
                    if (otherAllocation instanceof FixedWithNextNode) {
                        graph.addBeforeFixed(fixed, (FixedWithNextNode)otherAllocation);
                        continue;
                    }
                    assert (otherAllocation instanceof FloatingNode) : Assertions.errorMessage(otherAllocation, fixed, virtual, materializeEffects);
                }
                if (!objects.isEmpty()) {
                    CommitAllocationNode commit;
                    block19: {
                        if (fixed.predecessor() instanceof CommitAllocationNode) {
                            commit = (CommitAllocationNode)fixed.predecessor();
                        } else {
                            try (Iterator context = graph.withNodeSourcePosition(NodeSourcePosition.placeholder(graph.method()));){
                                AbstractBeginNode abs;
                                commit = graph.add(new CommitAllocationNode());
                                if (fixed.predecessor() != null && fixed.predecessor() instanceof FixedWithNextNode) {
                                    graph.addBeforeFixed(fixed, commit);
                                    break block19;
                                }
                                if (fixed instanceof AbstractBeginNode && (abs = (AbstractBeginNode)fixed).predecessor() instanceof ControlSplitNode) {
                                    BeginNode b = graph.add(new BeginNode());
                                    fixed.replaceAtPredecessor(b);
                                    b.setNext(fixed);
                                    graph.addBeforeFixed(fixed, commit);
                                    break block19;
                                }
                                throw GraalError.shouldNotReachHere("Complex control flow pattern - cannot easily insert materialization before " + String.valueOf(fixed));
                            }
                        }
                    }
                    for (AllocatedObjectNode obj : objects) {
                        graph.addWithoutUnique(obj);
                        commit.getVirtualObjects().add(obj.getVirtualObject());
                        obj.setCommit(commit);
                    }
                    for (ValueNode value : values) {
                        commit.getValues().add(graph.addOrUniqueWithInputs(value));
                    }
                    for (List monitorIds : locks) {
                        commit.addLocks(monitorIds);
                    }
                    commit.getEnsureVirtual().addAll(ensureVirtual);
                    assert (commit.usages().filter(AllocatedObjectNode.class).count() == commit.getUsageCount()) : Assertions.errorMessage(commit, commit.usages(), commit.getUsageCount());
                    List<AllocatedObjectNode> materializedValues = commit.usages().filter(AllocatedObjectNode.class).snapshot();
                    for (int i = 0; i < commit.getValues().size(); ++i) {
                        if (!materializedValues.contains(commit.getValues().get(i))) continue;
                        commit.getValues().set(i, ((AllocatedObjectNode)commit.getValues().get(i)).getVirtualObject());
                    }
                }
            }

            @Override
            void format(StringBuilder str) {
                this.format(str, new String[]{"otherAllocations", "fixed", "objects", "values", "locks", "ensureVirtual"}, new Object[]{otherAllocations, fixed, objects, values, locks, ensureVirtual});
            }
        });
    }

    private void materializeWithCommit(FixedNode fixed, VirtualObjectNode virtual, List<AllocatedObjectNode> objects, List<List<MonitorIdNode>> locks, List<ValueNode> values, List<Boolean> ensureVirtual, List<ValueNode> otherAllocations, GraphEffectList materializeEffects) {
        ObjectState obj = this.getObjectState(virtual);
        ValueNode[] entries = obj.getEntries();
        ValueNode representation = virtual.getMaterializedRepresentation(fixed, entries, obj.getLocks());
        this.escape(virtual.getObjectId(), representation);
        obj = this.getObjectState(virtual);
        PartialEscapeClosure.updateStatesForMaterialized(this, virtual, obj.getMaterializedValue());
        if (representation instanceof AllocatedObjectNode) {
            objects.add((AllocatedObjectNode)representation);
            locks.add(LockState.asList(obj.getLocks()));
            ensureVirtual.add(obj.getEnsureVirtualized());
            int pos = values.size();
            while (values.size() < pos + entries.length) {
                values.add(null);
            }
            for (int i = 0; i < entries.length; ++i) {
                if (entries[i] instanceof VirtualObjectNode) {
                    VirtualObjectNode entryVirtual = (VirtualObjectNode)entries[i];
                    ObjectState entryObj = this.getObjectState(entryVirtual);
                    if (entryObj.isVirtual()) {
                        this.materializeWithCommit(fixed, entryVirtual, objects, locks, values, ensureVirtual, otherAllocations, materializeEffects);
                        entryObj = this.getObjectState(entryVirtual);
                    }
                    values.set(pos + i, entryObj.getMaterializedValue());
                    continue;
                }
                values.set(pos + i, entries[i]);
            }
            this.objectMaterialized(virtual, (AllocatedObjectNode)representation, values.subList(pos, pos + entries.length));
        } else {
            VirtualUtil.trace(this.options, this.debug, "materialized %s as %s", virtual, representation);
            otherAllocations.add(representation);
            assert (obj.getLocks() == null);
        }
        materializeEffects.addLog(fixed.graph().getOptimizationLog(), optimizationLog -> optimizationLog.getPartialEscapeLog().objectMaterialized(virtual));
    }

    protected void objectMaterialized(VirtualObjectNode virtual, AllocatedObjectNode representation, List<ValueNode> values) {
        VirtualUtil.trace(this.options, this.debug, "materialized %s as %s with values %s", virtual, representation, values);
    }

    public void addObject(int virtual, ObjectState state) {
        this.ensureSize((int)virtual)[virtual] = state;
    }

    private ObjectState[] ensureSize(int objectId) {
        if (this.objectStates.length <= objectId) {
            this.objectStates = Arrays.copyOf(this.objectStates, Math.max(objectId * 2, 4));
            --this.arrayRefCount.refCount;
            this.arrayRefCount = new RefCount();
            return this.objectStates;
        }
        return this.getObjectStateArrayForModification();
    }

    public int getStateCount() {
        return this.objectStates.length;
    }

    @Override
    public String toString() {
        return super.toString() + ", Object States: " + Arrays.toString(this.objectStates);
    }

    @Override
    public boolean equivalentTo(T other) {
        int length = Math.max(this.objectStates.length, ((PartialEscapeBlockState)other).getStateCount());
        for (int i = 0; i < length; ++i) {
            ObjectState right;
            ObjectState left = this.getObjectStateOptional(i);
            if (left == (right = ((PartialEscapeBlockState)other).getObjectStateOptional(i))) continue;
            if (left == null || right == null) {
                return false;
            }
            if (left.equals(right)) continue;
            return false;
        }
        return true;
    }

    public void resetObjectStates(int size) {
        this.objectStates = new ObjectState[size];
    }

    public static boolean identicalObjectStates(PartialEscapeBlockState<?>[] states) {
        for (int i = 1; i < states.length; ++i) {
            if (states[0].objectStates == states[i].objectStates) continue;
            return false;
        }
        return true;
    }

    public static boolean identicalObjectStates(PartialEscapeBlockState<?>[] states, int object) {
        for (int i = 1; i < states.length; ++i) {
            if (states[0].objectStates[object] == states[i].objectStates[object]) continue;
            return false;
        }
        return true;
    }

    public void adoptAddObjectStates(PartialEscapeBlockState<?> other) {
        if (this.objectStates != null) {
            --this.arrayRefCount.refCount;
        }
        this.objectStates = other.objectStates;
        this.arrayRefCount = other.arrayRefCount;
        if (this.arrayRefCount.refCount == 1) {
            for (ObjectState state : this.objectStates) {
                if (state == null) continue;
                state.share();
            }
        }
        ++this.arrayRefCount.refCount;
    }

    private static class RefCount {
        private int refCount = 1;

        private RefCount() {
        }
    }

    public static final class Final
    extends PartialEscapeBlockState<Final> {
        public Final(OptionValues options, DebugContext debug) {
            super(options, debug);
        }

        public Final(Final other) {
            super(other);
        }
    }
}

