/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.virtual.phases.ea;

import java.util.Iterator;
import java.util.List;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.debug.TTY;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeFlood;
import jdk.graal.compiler.nodes.AbstractEndNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public final class VirtualUtil {
    private VirtualUtil() {
        GraalError.shouldNotReachHere("intentional");
    }

    public static boolean assertNonReachable(StructuredGraph graph, List<Node> obsoleteNodes) {
        DebugContext debug = graph.getDebug();
        NodeFlood flood = graph.createNodeFlood();
        EconomicMap path = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        flood.add(graph.start());
        for (Node current : flood) {
            if (current instanceof AbstractEndNode) {
                Iterator end = (AbstractEndNode)current;
                flood.add(((AbstractEndNode)((Object)end)).merge());
                if (path.containsKey((Object)((AbstractEndNode)((Object)end)).merge())) continue;
                path.put((Object)((AbstractEndNode)((Object)end)).merge(), (Object)end);
                continue;
            }
            for (Node successor : current.successors()) {
                flood.add(successor);
                if (path.containsKey((Object)successor)) continue;
                path.put((Object)successor, (Object)current);
            }
        }
        for (Node node : obsoleteNodes) {
            if (node instanceof FixedNode && !node.isDeleted()) assert (!flood.isMarked(node)) : node;
        }
        for (Node node : graph.getNodes()) {
            if (!flood.isMarked(node)) continue;
            for (Node input : node.inputs()) {
                flood.add(input);
                if (path.containsKey((Object)input)) continue;
                path.put((Object)input, (Object)node);
            }
        }
        for (Node current : flood) {
            for (Node input : current.inputs()) {
                flood.add(input);
                if (path.containsKey((Object)input)) continue;
                path.put((Object)input, (Object)current);
            }
        }
        boolean success = true;
        for (Node node : obsoleteNodes) {
            if (node.isDeleted() || !flood.isMarked(node) || node.getNodeClass().valueNumberable()) continue;
            TTY.println("offending node path:");
            Node current = node;
            TTY.print(current.toString());
            while (true) {
                if ((current = (Node)path.get((Object)current)) == null) {
                    continue;
                }
                TTY.print(" -> " + current.toString());
                if (current instanceof FixedNode && !obsoleteNodes.contains(current)) break;
            }
            success = false;
        }
        if (!success) {
            TTY.println();
            debug.forceDump(graph, "assertNonReachable", new Object[0]);
        }
        return success;
    }

    public static void trace(OptionValues options, DebugContext debug, String msg) {
        if (debug.areScopesEnabled() && GraalOptions.TraceEscapeAnalysis.getValue(options).booleanValue() && debug.isLogEnabled()) {
            debug.log(msg);
        }
    }

    public static void trace(OptionValues options, DebugContext debug, String format, Object obj) {
        if (debug.areScopesEnabled() && GraalOptions.TraceEscapeAnalysis.getValue(options).booleanValue() && debug.isLogEnabled()) {
            debug.logv(format, obj);
        }
    }

    public static void trace(OptionValues options, DebugContext debug, String format, Object obj, Object obj2) {
        if (debug.areScopesEnabled() && GraalOptions.TraceEscapeAnalysis.getValue(options).booleanValue() && debug.isLogEnabled()) {
            debug.logv(format, obj, obj2);
        }
    }

    public static void trace(OptionValues options, DebugContext debug, String format, Object obj, Object obj2, Object obj3) {
        if (debug.areScopesEnabled() && GraalOptions.TraceEscapeAnalysis.getValue(options).booleanValue() && debug.isLogEnabled()) {
            debug.logv(format, obj, obj2, obj3);
        }
    }

    public static void trace(OptionValues options, DebugContext debug, String format, Object obj, Object obj2, Object obj3, Object obj4) {
        if (debug.areScopesEnabled() && GraalOptions.TraceEscapeAnalysis.getValue(options).booleanValue() && debug.isLogEnabled()) {
            debug.logv(format, obj, obj2, obj3, obj4);
        }
    }

    public static boolean matches(StructuredGraph graph, String filter) {
        if (filter != null) {
            return VirtualUtil.matchesHelper(graph, filter);
        }
        return true;
    }

    private static boolean matchesHelper(StructuredGraph graph, String filter) {
        if (filter.startsWith("~")) {
            ResolvedJavaMethod method = graph.method();
            return method == null || !method.format("%H.%n").contains(filter.substring(1));
        }
        ResolvedJavaMethod method = graph.method();
        return method != null && method.format("%H.%n").contains(filter);
    }
}

