/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.bytecode;

import jdk.graal.compiler.bytecode.BytecodeStream;
import jdk.graal.compiler.bytecode.BytecodeSwitch;

public class BytecodeTableSwitch
extends BytecodeSwitch {
    private static final int OFFSET_TO_LOW_KEY = 4;
    private static final int OFFSET_TO_HIGH_KEY = 8;
    private static final int OFFSET_TO_FIRST_JUMP_OFFSET = 12;
    private static final int JUMP_OFFSET_SIZE = 4;

    public BytecodeTableSwitch(BytecodeStream stream, int bci) {
        super(stream, bci);
    }

    public int lowKey() {
        return this.stream.readInt(this.alignedBci + 4);
    }

    public int highKey() {
        return this.stream.readInt(this.alignedBci + 8);
    }

    @Override
    public int keyAt(int i) {
        return this.lowKey() + i;
    }

    @Override
    public int offsetAt(int i) {
        return this.stream.readInt(this.alignedBci + 12 + 4 * i);
    }

    @Override
    public int numberOfCases() {
        return this.highKey() - this.lowKey() + 1;
    }

    @Override
    public int size() {
        return this.alignedBci + 12 + 4 * this.numberOfCases() - this.bci;
    }
}

