/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core;

import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import jdk.graal.compiler.core.GraalServiceThread;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.core.common.util.Util;
import jdk.graal.compiler.debug.TTY;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.serviceprovider.GraalServices;
import jdk.graal.compiler.serviceprovider.IsolateUtil;
import jdk.vm.ci.common.NativeImageReinitialize;
import jdk.vm.ci.services.Services;

public final class CompilationWatchDog
implements Runnable,
AutoCloseable {
    public static final Object CURRENT_THREAD_LABEL = new Object(){

        public String toString() {
            Object isolateID = IsolateUtil.getIsolateID(false);
            if (!((String)isolateID).isEmpty()) {
                isolateID = "@" + (String)isolateID;
            }
            return Thread.currentThread().getName() + (String)isolateID;
        }
    };
    private final Thread watchedThread;
    private final EventHandler eventHandler;
    private final int vmExitDelay;
    private volatile CompilationIdentifier compilation;
    private StackTraceElement[] lastStackTrace;
    private final ScheduledExecutorService singleShotExecutor;
    private final boolean debug = Boolean.parseBoolean(Services.getSavedProperty((String)"debug.graal.CompilationWatchDog"));
    private final ScheduledFuture<?> task;
    @NativeImageReinitialize
    private static ScheduledExecutorService watchDogService;

    CompilationWatchDog(CompilationIdentifier compilation, Thread watchedThread, int delay, int vmExitDelay, boolean singleShotExecutor, EventHandler eventHandler) {
        this.compilation = compilation;
        this.watchedThread = watchedThread;
        this.vmExitDelay = vmExitDelay;
        this.eventHandler = eventHandler == null ? EventHandler.DEFAULT : eventHandler;
        this.trace("started compiling %s", compilation);
        if (singleShotExecutor) {
            this.singleShotExecutor = CompilationWatchDog.createExecutor();
            this.task = this.singleShotExecutor.schedule(this, (long)delay, TimeUnit.SECONDS);
        } else {
            this.singleShotExecutor = null;
            this.task = CompilationWatchDog.schedule(this, delay);
        }
    }

    private void stopCompilation() {
        this.trace("stopped compiling %s", this.compilation);
        this.compilation = null;
        this.task.cancel(true);
        if (this.singleShotExecutor != null) {
            this.singleShotExecutor.shutdownNow();
            while (!this.singleShotExecutor.isTerminated()) {
                try {
                    this.singleShotExecutor.awaitTermination(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private boolean recordStackTrace(StackTraceElement[] newStackTrace) {
        if (this.lastStackTrace == null || !Arrays.equals(this.lastStackTrace, newStackTrace)) {
            this.lastStackTrace = newStackTrace;
            return true;
        }
        return false;
    }

    private void trace(String format, Object ... args) {
        if (this.debug) {
            TTY.println(String.valueOf(CURRENT_THREAD_LABEL) + ": " + String.format(format, args));
        }
    }

    private static double secs(long ms) {
        return (double)ms / 1000.0;
    }

    public String toString() {
        return "WatchDog[" + this.watchedThread.getName() + "]";
    }

    @Override
    public void run() {
        try {
            CompilationIdentifier comp = this.compilation;
            long start = System.currentTimeMillis();
            long elapsed = 0L;
            int reportDelay = 1000;
            long nextReport = start;
            long lastUniqueStackTrace = start;
            while (this.compilation != null) {
                long now = System.currentTimeMillis();
                comp = this.compilation;
                this.trace("took a stack trace [%.3f seconds]", CompilationWatchDog.secs(elapsed));
                boolean uniqueStackTrace = this.recordStackTrace(this.watchedThread.getStackTrace());
                if (uniqueStackTrace) {
                    lastUniqueStackTrace = now;
                }
                int stuckTime = (int)((now - lastUniqueStackTrace) / 1000L);
                if (this.vmExitDelay != 0 && stuckTime >= this.vmExitDelay) {
                    this.eventHandler.onStuckCompilation(this, this.watchedThread, comp, this.lastStackTrace, stuckTime);
                } else if (uniqueStackTrace && now >= nextReport) {
                    this.eventHandler.onLongCompilation(this, this.watchedThread, comp, elapsed, this.lastStackTrace);
                    nextReport = now + (long)reportDelay;
                    reportDelay <<= 1;
                }
                try {
                    Thread.sleep(1000L);
                    elapsed = System.currentTimeMillis() - start;
                }
                catch (InterruptedException e) {
                    elapsed = System.currentTimeMillis() - start;
                    this.trace("interrupted [%.3f seconds]", CompilationWatchDog.secs(elapsed));
                }
            }
            this.trace("stopped watching %s [%.3f seconds]", comp, CompilationWatchDog.secs(elapsed));
        }
        catch (Throwable t) {
            this.eventHandler.onException(t);
        }
    }

    private static synchronized ScheduledFuture<?> schedule(CompilationWatchDog watchdog, int delay) {
        if (watchDogService == null) {
            watchDogService = CompilationWatchDog.createExecutor();
        }
        return watchDogService.schedule(watchdog, (long)delay, TimeUnit.SECONDS);
    }

    private static ScheduledExecutorService createExecutor() {
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                GraalServiceThread thread = new GraalServiceThread(CompilationWatchDog.class.getSimpleName(), r);
                thread.setName("WatchDog-" + GraalServices.getThreadId(thread));
                thread.setPriority(10);
                thread.setDaemon(true);
                return thread;
            }
        };
        int poolSize = 1;
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(poolSize, threadFactory);
        executor.setRemoveOnCancelPolicy(true);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public static CompilationWatchDog watch(CompilationIdentifier compilation, OptionValues options, boolean singleShotExecutor, EventHandler eventHandler) {
        int delay = Options.CompilationWatchDogStartDelay.getValue(options);
        if (Services.IS_BUILDING_NATIVE_IMAGE && !Options.CompilationWatchDogStartDelay.hasBeenSet(options)) {
            delay = 0;
        }
        if (delay > 0) {
            Thread watchedThread = Thread.currentThread();
            int vmExitDelay = Options.CompilationWatchDogVMExitDelay.getValue(options);
            CompilationWatchDog watchDog = new CompilationWatchDog(compilation, watchedThread, delay, vmExitDelay, singleShotExecutor, eventHandler);
            return watchDog;
        }
        return null;
    }

    @Override
    public void close() {
        this.stopCompilation();
    }

    public static interface EventHandler {
        public static final int STUCK_COMPILATION_EXIT_CODE = 84;
        public static final EventHandler DEFAULT = new EventHandler(){};

        default public void onLongCompilation(CompilationWatchDog watchDog, Thread watched, CompilationIdentifier compilation, long elapsed, StackTraceElement[] stackTrace) {
            TTY.printf("======================= WATCH DOG =======================%n%s: detected long running compilation %s [%.3f seconds]%n%s", CURRENT_THREAD_LABEL, compilation, CompilationWatchDog.secs(elapsed), Util.toString(stackTrace));
        }

        default public void onStuckCompilation(CompilationWatchDog watchDog, Thread watched, CompilationIdentifier compilation, StackTraceElement[] stackTrace, int stuckTime) {
            TTY.printf("======================= WATCH DOG =======================%n%s: observed identical stack traces for %d seconds, indicating a stuck compilation %s%n%s%n", CURRENT_THREAD_LABEL, stuckTime, compilation, Util.toString(stackTrace));
        }

        default public void onException(Throwable exception) {
            if (!(exception instanceof OutOfMemoryError)) {
                exception.printStackTrace(TTY.out);
            }
        }
    }

    public static class Options {
        public static final OptionKey<Integer> CompilationWatchDogStartDelay = new OptionKey<Integer>(0);
        public static final OptionKey<Integer> CompilationWatchDogVMExitDelay = new OptionKey<Integer>(0);
    }
}

