/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core;

import java.util.List;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.core.common.cfg.BlockMap;
import jdk.graal.compiler.core.gen.NodeLIRBuilder;
import jdk.graal.compiler.debug.CounterKey;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.gen.LIRGenerationResult;
import jdk.graal.compiler.lir.gen.LIRGenerator;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.lir.phases.LIRPhase;
import jdk.graal.compiler.lir.ssa.SSAUtil;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.code.TargetDescription;

public class LIRGenerationPhase
extends LIRPhase<LIRGenerationContext> {
    private static final CounterKey instructionCounter = DebugContext.counter("GeneratedLIRInstructions");
    private static final CounterKey nodeCount = DebugContext.counter("FinalNodeCount");

    @Override
    protected final void run(TargetDescription target, LIRGenerationResult lirGenRes, LIRGenerationContext context) {
        BasicBlock[] blocks;
        NodeLIRBuilder nodeLirBuilder = context.nodeLirBuilder;
        StructuredGraph graph = context.graph;
        StructuredGraph.ScheduleResult schedule = context.schedule;
        for (BasicBlock b : blocks = lirGenRes.getLIR().getControlFlowGraph().getBlocks()) {
            LIRGenerationPhase.matchBlock(nodeLirBuilder, (HIRBlock)b, schedule);
        }
        for (BasicBlock b : blocks) {
            LIRGenerationPhase.emitBlock(nodeLirBuilder, lirGenRes, (HIRBlock)b, graph, schedule.getBlockToNodesMap());
        }
        ((LIRGenerator)context.lirGen).beforeRegisterAllocation();
        assert (SSAUtil.verifySSAForm(lirGenRes.getLIR()));
        nodeCount.add(graph.getDebug(), graph.getNodeCount());
    }

    private static void emitBlock(NodeLIRBuilderTool nodeLirGen, LIRGenerationResult lirGenRes, HIRBlock b, StructuredGraph graph, BlockMap<List<Node>> blockMap) {
        assert (!LIRGenerationPhase.isProcessed(lirGenRes, b)) : "Block already processed " + String.valueOf(b);
        assert (LIRGenerationPhase.verifyPredecessors(lirGenRes, b));
        nodeLirGen.doBlock(b, graph, blockMap);
        LIR lir = lirGenRes.getLIR();
        DebugContext debug = lir.getDebug();
        instructionCounter.add(debug, lir.getLIRforBlock(b).size());
    }

    private static void matchBlock(NodeLIRBuilder nodeLirGen, HIRBlock b, StructuredGraph.ScheduleResult schedule) {
        nodeLirGen.matchBlock(b, schedule);
    }

    private static boolean verifyPredecessors(LIRGenerationResult lirGenRes, HIRBlock block) {
        for (int i = 0; i < block.getPredecessorCount(); ++i) {
            HIRBlock pred = (HIRBlock)block.getPredecessorAt(i);
            if (!block.isLoopHeader() || !pred.isLoopEnd()) assert (LIRGenerationPhase.isProcessed(lirGenRes, pred)) : "Predecessor not yet processed " + String.valueOf(pred);
        }
        return true;
    }

    private static boolean isProcessed(LIRGenerationResult lirGenRes, HIRBlock b) {
        return lirGenRes.getLIR().getLIRforBlock(b) != null;
    }

    public static final class LIRGenerationContext {
        private final NodeLIRBuilder nodeLirBuilder;
        private final LIRGeneratorTool lirGen;
        private final StructuredGraph graph;
        private final StructuredGraph.ScheduleResult schedule;

        public LIRGenerationContext(LIRGeneratorTool lirGen, NodeLIRBuilderTool nodeLirBuilder, StructuredGraph graph, StructuredGraph.ScheduleResult schedule) {
            this.nodeLirBuilder = (NodeLIRBuilder)nodeLirBuilder;
            this.lirGen = lirGen;
            this.graph = graph;
            this.schedule = schedule;
        }
    }
}

