/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.aarch64;

import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.core.aarch64.AArch64LIRGenerator;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.calc.FloatConvert;
import jdk.graal.compiler.core.common.memory.MemoryExtendKind;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.core.target.Backend;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.CastValue;
import jdk.graal.compiler.lir.ConstantValue;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.LIRValueUtil;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.lir.aarch64.AArch64AddressValue;
import jdk.graal.compiler.lir.aarch64.AArch64ArithmeticOp;
import jdk.graal.compiler.lir.aarch64.AArch64BitManipulationOp;
import jdk.graal.compiler.lir.aarch64.AArch64BitSwapOp;
import jdk.graal.compiler.lir.aarch64.AArch64Convert;
import jdk.graal.compiler.lir.aarch64.AArch64FloatToHalfFloatOp;
import jdk.graal.compiler.lir.aarch64.AArch64HalfFloatToFloatOp;
import jdk.graal.compiler.lir.aarch64.AArch64MathCopySignOp;
import jdk.graal.compiler.lir.aarch64.AArch64MathSignumOp;
import jdk.graal.compiler.lir.aarch64.AArch64Move;
import jdk.graal.compiler.lir.aarch64.AArch64NormalizedUnsignedCompareOp;
import jdk.graal.compiler.lir.aarch64.AArch64ReinterpretOp;
import jdk.graal.compiler.lir.aarch64.AArch64RoundFloatToIntegerOp;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGenerator;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;

public class AArch64ArithmeticLIRGenerator
extends ArithmeticLIRGenerator
implements ArithmeticLIRGeneratorTool {
    private final AllocatableValue nullRegisterValue;

    public AArch64ArithmeticLIRGenerator(AllocatableValue nullRegisterValue) {
        this.nullRegisterValue = nullRegisterValue;
    }

    @Override
    public AArch64LIRGenerator getLIRGen() {
        return (AArch64LIRGenerator)super.getLIRGen();
    }

    public boolean mustReplaceNullWithNullRegister(JavaConstant nullConstant) {
        return this.nullRegisterValue != null && JavaConstant.NULL_POINTER.equals((Object)nullConstant);
    }

    public AllocatableValue getNullRegisterValue() {
        assert (this.nullRegisterValue != null) : "Should not be requesting null register value.";
        return this.nullRegisterValue;
    }

    @Override
    protected boolean isNumericInteger(PlatformKind kind) {
        return ((AArch64Kind)kind).isInteger();
    }

    @Override
    protected Variable emitAdd(LIRKind resultKind, Value a, Value b, boolean setFlags) {
        if (this.isNumericInteger(a.getPlatformKind())) {
            AArch64ArithmeticOp op = setFlags ? AArch64ArithmeticOp.ADDS : AArch64ArithmeticOp.ADD;
            return this.emitBinary(resultKind, op, true, a, b);
        }
        assert (!setFlags) : "Cannot set flags on floating point arithmetic";
        return this.emitBinary(resultKind, AArch64ArithmeticOp.FADD, true, a, b);
    }

    @Override
    protected Variable emitSub(LIRKind resultKind, Value a, Value b, boolean setFlags) {
        if (this.isNumericInteger(a.getPlatformKind())) {
            AArch64ArithmeticOp op = setFlags ? AArch64ArithmeticOp.SUBS : AArch64ArithmeticOp.SUB;
            return this.emitBinary(resultKind, op, false, a, b);
        }
        assert (!setFlags) : "Cannot set flags on floating point arithmetic";
        return this.emitBinary(resultKind, AArch64ArithmeticOp.FSUB, false, a, b);
    }

    @Override
    public Value emitMul(Value a, Value b, boolean setFlags) {
        AArch64ArithmeticOp intOp = setFlags ? AArch64ArithmeticOp.MULVS : AArch64ArithmeticOp.MUL;
        return this.emitBinary(LIRKind.combine(a, b), this.getOpCode(a, intOp, AArch64ArithmeticOp.FMUL), true, a, b);
    }

    @Override
    public Value emitMulHigh(Value a, Value b) {
        assert (this.assertIsNumericInteger(a.getPlatformKind()));
        return this.emitBinary(LIRKind.combine(a, b), AArch64ArithmeticOp.SMULH, true, a, b);
    }

    @Override
    public Value emitUMulHigh(Value a, Value b) {
        assert (this.assertIsNumericInteger(a.getPlatformKind()));
        return this.emitBinary(LIRKind.combine(a, b), AArch64ArithmeticOp.UMULH, true, a, b);
    }

    public Value emitMNeg(Value a, Value b) {
        assert (this.isNumericInteger(a.getPlatformKind()) && this.isNumericInteger(b.getPlatformKind())) : String.valueOf(a) + " " + String.valueOf(b);
        return this.emitBinary(LIRKind.combine(a, b), AArch64ArithmeticOp.MNEG, true, a, b);
    }

    @Override
    public Value emitDiv(Value a, Value b, LIRFrameState state) {
        return this.emitBinary(LIRKind.combine(a, b), this.getOpCode(a, AArch64ArithmeticOp.DIV, AArch64ArithmeticOp.FDIV), false, (Value)this.asAllocatable(a), (Value)this.asAllocatable(b));
    }

    @Override
    public Value emitRem(Value a, Value b, LIRFrameState state) {
        if (this.isNumericInteger(a.getPlatformKind())) {
            return this.emitBinary(LIRKind.combine(a, b), AArch64ArithmeticOp.REM, false, (Value)this.asAllocatable(a), (Value)this.asAllocatable(b));
        }
        switch ((AArch64Kind)a.getPlatformKind()) {
            case SINGLE: {
                ForeignCallLinkage fremCall = this.getLIRGen().getForeignCalls().lookupForeignCall(Backend.ARITHMETIC_FREM);
                return this.getLIRGen().emitForeignCall(fremCall, state, a, b);
            }
            case DOUBLE: {
                ForeignCallLinkage dremCall = this.getLIRGen().getForeignCalls().lookupForeignCall(Backend.ARITHMETIC_DREM);
                return this.getLIRGen().emitForeignCall(dremCall, state, a, b);
            }
        }
        GraalError.shouldNotReachHere("emitRem on unexpected kind " + String.valueOf(a.getPlatformKind()));
        return null;
    }

    @Override
    public Value emitUDiv(Value a, Value b, LIRFrameState state) {
        assert (this.assertIsNumericInteger(a.getPlatformKind()));
        return this.emitBinary(LIRKind.combine(a, b), AArch64ArithmeticOp.UDIV, false, (Value)this.asAllocatable(a), (Value)this.asAllocatable(b));
    }

    @Override
    public Value emitURem(Value a, Value b, LIRFrameState state) {
        assert (this.assertIsNumericInteger(a.getPlatformKind()));
        return this.emitBinary(LIRKind.combine(a, b), AArch64ArithmeticOp.UREM, false, (Value)this.asAllocatable(a), (Value)this.asAllocatable(b));
    }

    @Override
    public Value emitAnd(Value a, Value b) {
        assert (this.assertIsNumericInteger(a.getPlatformKind()));
        return this.emitBinary(LIRKind.combine(a, b), AArch64ArithmeticOp.AND, true, a, b);
    }

    @Override
    public Value emitOr(Value a, Value b) {
        assert (this.assertIsNumericInteger(a.getPlatformKind()));
        return this.emitBinary(LIRKind.combine(a, b), AArch64ArithmeticOp.OR, true, a, b);
    }

    @Override
    public Value emitXor(Value a, Value b) {
        assert (this.assertIsNumericInteger(a.getPlatformKind()));
        return this.emitBinary(LIRKind.combine(a, b), AArch64ArithmeticOp.XOR, true, a, b);
    }

    @Override
    public Value emitXorFP(Value a, Value b) {
        assert ((a.getPlatformKind() == AArch64Kind.SINGLE || a.getPlatformKind() == AArch64Kind.DOUBLE) && a.getPlatformKind() == b.getPlatformKind()) : String.valueOf(a) + " " + String.valueOf(b);
        LIRKind simdKind = a.getPlatformKind() == AArch64Kind.SINGLE ? LIRKind.value((PlatformKind)AArch64Kind.V32_BYTE) : LIRKind.value((PlatformKind)AArch64Kind.V64_BYTE);
        Variable result = this.getLIRGen().newVariable(simdKind);
        CastValue castA = new CastValue(simdKind, this.asAllocatable(a));
        CastValue castB = new CastValue(simdKind, this.asAllocatable(b));
        this.getLIRGen().append(AArch64ArithmeticOp.generateASIMDBinaryInstruction(AArch64ArithmeticOp.XOR, result, castA, castB));
        return new CastValue(LIRKind.combine(a, b), result);
    }

    @Override
    public Value emitShl(Value a, Value b) {
        assert (this.assertIsNumericInteger(a.getPlatformKind()));
        return this.emitBinary(LIRKind.combine(a, b), AArch64ArithmeticOp.LSL, false, a, b);
    }

    @Override
    public Value emitShr(Value a, Value b) {
        assert (this.assertIsNumericInteger(a.getPlatformKind()));
        return this.emitBinary(LIRKind.combine(a, b), AArch64ArithmeticOp.ASR, false, a, b);
    }

    @Override
    public Value emitUShr(Value a, Value b) {
        assert (this.assertIsNumericInteger(a.getPlatformKind()));
        return this.emitBinary(LIRKind.combine(a, b), AArch64ArithmeticOp.LSR, false, a, b);
    }

    @Override
    public Value emitFloatConvert(FloatConvert op, Value inputVal, boolean canBeNaN, boolean canOverflow) {
        AArch64Kind resultPlatformKind = AArch64ArithmeticLIRGenerator.getFloatConvertResultKind(op);
        LIRKind resultLirKind = LIRKind.combine(inputVal).changeType((PlatformKind)resultPlatformKind);
        Variable result = this.getLIRGen().newVariable(resultLirKind);
        this.getLIRGen().append(new AArch64Convert.FloatConvertOp(op, result, this.asAllocatable(inputVal)));
        return result;
    }

    public Value emitIntegerMAdd(Value a, Value b, Value c, boolean isI2L) {
        return this.emitMultiplyAddSub(isI2L ? AArch64ArithmeticOp.SMADDL : AArch64ArithmeticOp.MADD, a, b, c);
    }

    public Value emitIntegerMSub(Value a, Value b, Value c, boolean isI2L) {
        return this.emitMultiplyAddSub(isI2L ? AArch64ArithmeticOp.SMSUBL : AArch64ArithmeticOp.MSUB, a, b, c);
    }

    protected Value emitMultiplyAddSub(AArch64ArithmeticOp op, Value a, Value b, Value c) {
        Variable result;
        assert (a.getPlatformKind() == b.getPlatformKind()) : "Kind must match a=" + String.valueOf(a) + " b=" + String.valueOf(b);
        if (op == AArch64ArithmeticOp.SMADDL || op == AArch64ArithmeticOp.SMSUBL) {
            assert (a.getPlatformKind() != c.getPlatformKind()) : String.valueOf(a) + " " + String.valueOf(c);
            result = this.getLIRGen().newVariable(LIRKind.combine(c));
        } else {
            assert (a.getPlatformKind() == c.getPlatformKind()) : String.valueOf(a) + " " + String.valueOf(c);
            if (op == AArch64ArithmeticOp.FMADD) {
                assert (a.getPlatformKind() == AArch64Kind.SINGLE || a.getPlatformKind() == AArch64Kind.DOUBLE) : a;
            } else {
                assert (op == AArch64ArithmeticOp.MADD || op == AArch64ArithmeticOp.MSUB) : op;
                assert (this.assertIsNumericInteger(a.getPlatformKind()));
            }
            result = this.getLIRGen().newVariable(LIRKind.combine(a, b, c));
        }
        AllocatableValue x = this.moveSp(this.asAllocatable(a));
        AllocatableValue y = this.moveSp(this.asAllocatable(b));
        AllocatableValue z = this.moveSp(this.asAllocatable(c));
        this.getLIRGen().append(new AArch64ArithmeticOp.MultiplyAddSubOp(op, result, x, y, z));
        return result;
    }

    protected static AArch64Kind getFloatConvertResultKind(FloatConvert op) {
        switch (op) {
            case F2I: 
            case D2I: {
                return AArch64Kind.DWORD;
            }
            case F2L: 
            case D2L: {
                return AArch64Kind.QWORD;
            }
            case I2F: 
            case L2F: 
            case D2F: {
                return AArch64Kind.SINGLE;
            }
            case I2D: 
            case L2D: 
            case F2D: {
                return AArch64Kind.DOUBLE;
            }
        }
        throw GraalError.shouldNotReachHereUnexpectedValue((Object)op);
    }

    @Override
    public Value emitReinterpret(LIRKind to, Value inputVal) {
        ValueKind from = inputVal.getValueKind();
        if (to.equals(from)) {
            return inputVal;
        }
        Variable result = this.getLIRGen().newVariable(to);
        this.getLIRGen().append(new AArch64ReinterpretOp(result, this.asAllocatable(inputVal)));
        return result;
    }

    @Override
    public Value emitNarrow(Value inputVal, int toBits) {
        if (inputVal.getPlatformKind() == AArch64Kind.QWORD && toBits <= 32) {
            LIRKind resultKind = AArch64ArithmeticLIRGenerator.getLIRKindForBitSize(toBits, inputVal);
            assert (resultKind.getPlatformKind() == AArch64Kind.DWORD) : resultKind;
            return new CastValue(resultKind, this.asAllocatable(inputVal));
        }
        return inputVal;
    }

    @Override
    public Value emitZeroExtend(Value inputVal, int fromBits, int toBits, boolean requiresExplicitZeroExtend, boolean requiresLIRKindChange) {
        assert (fromBits <= toBits && toBits <= 64) : fromBits + " " + toBits;
        if (fromBits == toBits) {
            return inputVal;
        }
        LIRKind resultKind = AArch64ArithmeticLIRGenerator.getLIRKindForBitSize(toBits, inputVal);
        long mask = NumUtil.getNbitNumberLong(fromBits);
        ConstantValue maskValue = new ConstantValue(resultKind, (Constant)JavaConstant.forLong((long)mask));
        return this.emitBinary(resultKind, AArch64ArithmeticOp.AND, true, inputVal, (Value)maskValue);
    }

    @Override
    public Value emitSignExtend(Value inputVal, int fromBits, int toBits) {
        assert (fromBits <= toBits && toBits <= 64) : fromBits + " " + toBits;
        LIRKind resultKind = AArch64ArithmeticLIRGenerator.getLIRKindForBitSize(toBits, inputVal);
        if (fromBits == toBits) {
            return inputVal;
        }
        if (LIRValueUtil.isJavaConstant(inputVal)) {
            JavaConstant javaConstant = LIRValueUtil.asJavaConstant(inputVal);
            long constant = javaConstant.isNull() ? 0L : javaConstant.asLong();
            int shiftSize = 64 - fromBits;
            long signExtendedValue = constant << shiftSize >> shiftSize;
            return new ConstantValue(resultKind, (Constant)JavaConstant.forPrimitiveInt((int)toBits, (long)signExtendedValue));
        }
        Variable result = this.getLIRGen().newVariable(resultKind);
        this.getLIRGen().append(new AArch64Convert.SignExtendOp(result, this.asAllocatable(inputVal), fromBits, toBits));
        return result;
    }

    private static LIRKind getLIRKindForBitSize(int bitSize, Value inputValue) {
        assert (bitSize <= 64) : bitSize + " " + String.valueOf(inputValue);
        if (bitSize <= 32) {
            return LIRKind.combine(inputValue).changeType((PlatformKind)AArch64Kind.DWORD);
        }
        return LIRKind.combine(inputValue).changeType((PlatformKind)AArch64Kind.QWORD);
    }

    protected Variable emitBinary(LIRKind resultKind, AArch64ArithmeticOp op, boolean commutative, Value a, Value b) {
        Variable result = this.getLIRGen().newVariable(resultKind);
        this.emitBinary(result, op, commutative, a, b);
        return result;
    }

    protected void emitBinary(AllocatableValue result, AArch64ArithmeticOp op, boolean commutative, Value a, Value b) {
        AArch64Kind opKind = (AArch64Kind)result.getPlatformKind();
        if (AArch64ArithmeticLIRGenerator.isValidBinaryConstant(op, opKind, b)) {
            this.emitBinaryConst(result, op, this.asAllocatable(a), LIRValueUtil.asJavaConstant(b));
        } else if (commutative && AArch64ArithmeticLIRGenerator.isValidBinaryConstant(op, opKind, a)) {
            this.emitBinaryConst(result, op, this.asAllocatable(b), LIRValueUtil.asJavaConstant(a));
        } else {
            this.emitBinaryVar(result, op, this.asAllocatable(a), this.asAllocatable(b));
        }
    }

    private void emitBinaryVar(AllocatableValue result, AArch64ArithmeticOp op, AllocatableValue a, AllocatableValue b) {
        AllocatableValue x = this.moveSp(a);
        AllocatableValue y = this.moveSp(b);
        this.getLIRGen().append(new AArch64ArithmeticOp.BinaryOp(op, result, x, y));
    }

    public void emitBinaryConst(AllocatableValue result, AArch64ArithmeticOp op, AllocatableValue a, JavaConstant b) {
        AllocatableValue x = this.moveSp(a);
        this.getLIRGen().append(new AArch64ArithmeticOp.BinaryConstOp(op, result, x, b));
    }

    private static boolean isValidBinaryConstant(AArch64ArithmeticOp op, AArch64Kind opKind, Value val) {
        if (!LIRValueUtil.isJavaConstant(val)) {
            return false;
        }
        JavaConstant constValue = LIRValueUtil.asJavaConstant(val);
        switch (op.category) {
            case LOGICAL: {
                return AArch64ArithmeticLIRGenerator.isLogicalConstant(opKind, constValue);
            }
            case ADDSUBTRACT: {
                return AArch64ArithmeticLIRGenerator.isAddSubtractConstant(constValue);
            }
            case SHIFT: {
                return true;
            }
            case NONE: {
                return false;
            }
        }
        throw GraalError.shouldNotReachHereUnexpectedValue((Object)op.category);
    }

    private static boolean isLogicalConstant(AArch64Kind kind, JavaConstant constValue) {
        long value = constValue.asLong();
        switch (kind) {
            case DWORD: {
                return AArch64MacroAssembler.isLogicalImmediate(32, value);
            }
            case QWORD: {
                return AArch64MacroAssembler.isLogicalImmediate(64, value);
            }
        }
        throw GraalError.shouldNotReachHereUnexpectedValue(kind);
    }

    public static boolean isAddSubtractConstant(JavaConstant constValue) {
        switch (constValue.getJavaKind().getStackKind()) {
            case Int: 
            case Long: {
                return AArch64MacroAssembler.isAddSubtractImmediate(constValue.asLong(), true);
            }
            case Object: {
                return false;
            }
        }
        throw GraalError.shouldNotReachHereUnexpectedValue(constValue.getJavaKind().getStackKind());
    }

    @Override
    public Value emitNegate(Value inputVal, boolean setFlags) {
        if (this.isNumericInteger(inputVal.getPlatformKind())) {
            AArch64ArithmeticOp op = setFlags ? AArch64ArithmeticOp.NEGS : AArch64ArithmeticOp.NEG;
            return this.emitUnary(op, inputVal);
        }
        assert (!setFlags) : "Cannot set flags on floating point arithmetic";
        return this.emitUnary(AArch64ArithmeticOp.FNEG, inputVal);
    }

    @Override
    public Value emitNot(Value input) {
        assert (this.assertIsNumericInteger(input.getPlatformKind()));
        return this.emitUnary(AArch64ArithmeticOp.NOT, input);
    }

    @Override
    public Value emitMathAbs(Value input) {
        return this.emitUnary(this.getOpCode(input, AArch64ArithmeticOp.ABS, AArch64ArithmeticOp.FABS), input);
    }

    @Override
    public Value emitMathMax(Value a, Value b) {
        assert (a.getPlatformKind() == b.getPlatformKind()) : "Kind must match a=" + String.valueOf(a) + " b=" + String.valueOf(b);
        assert (a.getPlatformKind() == AArch64Kind.DOUBLE || a.getPlatformKind() == AArch64Kind.SINGLE) : a;
        return this.emitBinary(LIRKind.combine(a, b), AArch64ArithmeticOp.FMAX, true, a, b);
    }

    @Override
    public Value emitMathMin(Value a, Value b) {
        assert (a.getPlatformKind() == b.getPlatformKind()) : "Kind must match a=" + String.valueOf(a) + " b=" + String.valueOf(b);
        assert (a.getPlatformKind() == AArch64Kind.DOUBLE || a.getPlatformKind() == AArch64Kind.SINGLE) : a;
        return this.emitBinary(LIRKind.combine(a, b), AArch64ArithmeticOp.FMIN, true, a, b);
    }

    @Override
    public Value emitMathSqrt(Value input) {
        assert (input.getPlatformKind() == AArch64Kind.DOUBLE || input.getPlatformKind() == AArch64Kind.SINGLE) : input;
        return this.emitUnary(AArch64ArithmeticOp.FSQRT, input);
    }

    @Override
    public Value emitMathSignum(Value input) {
        assert (input.getPlatformKind() == AArch64Kind.DOUBLE || input.getPlatformKind() == AArch64Kind.SINGLE) : input;
        Variable result = this.getLIRGen().newVariable(input.getValueKind());
        this.getLIRGen().append(new AArch64MathSignumOp(this.getLIRGen(), (Value)result, this.asAllocatable(input)));
        return result;
    }

    @Override
    public Value emitMathCopySign(Value magnitude, Value sign) {
        assert (magnitude.getPlatformKind() == AArch64Kind.DOUBLE || magnitude.getPlatformKind() == AArch64Kind.SINGLE) : magnitude;
        Variable result = this.getLIRGen().newVariable(magnitude.getValueKind());
        this.getLIRGen().append(new AArch64MathCopySignOp((Value)result, this.asAllocatable(magnitude), this.asAllocatable(sign)));
        return result;
    }

    public Variable emitBitScanForward(Value value) {
        throw GraalError.unimplementedOverride();
    }

    @Override
    public Value emitBitCount(Value operand) {
        assert (((AArch64Kind)operand.getPlatformKind()).isInteger());
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(operand).changeType((PlatformKind)AArch64Kind.DWORD));
        this.getLIRGen().append(new AArch64BitManipulationOp(this.getLIRGen(), AArch64BitManipulationOp.BitManipulationOpCode.POPCNT, result, this.asAllocatable(operand)));
        return result;
    }

    @Override
    public Value emitBitScanReverse(Value value) {
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(value).changeType((PlatformKind)AArch64Kind.DWORD));
        this.getLIRGen().append(new AArch64BitManipulationOp(this.getLIRGen(), AArch64BitManipulationOp.BitManipulationOpCode.BSR, result, this.asAllocatable(value)));
        return result;
    }

    @Override
    public Value emitFusedMultiplyAdd(Value a, Value b, Value c) {
        return this.emitMultiplyAddSub(AArch64ArithmeticOp.FMADD, a, b, c);
    }

    @Override
    public Value emitCountLeadingZeros(Value value) {
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(value).changeType((PlatformKind)AArch64Kind.DWORD));
        this.getLIRGen().append(new AArch64BitManipulationOp(this.getLIRGen(), AArch64BitManipulationOp.BitManipulationOpCode.CLZ, result, this.asAllocatable(value)));
        return result;
    }

    @Override
    public Value emitCountTrailingZeros(Value value) {
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(value).changeType((PlatformKind)AArch64Kind.DWORD));
        this.getLIRGen().append(new AArch64BitManipulationOp(this.getLIRGen(), AArch64BitManipulationOp.BitManipulationOpCode.CTZ, result, this.asAllocatable(value)));
        return result;
    }

    private Variable emitUnary(AArch64ArithmeticOp op, Value inputVal) {
        AllocatableValue input = this.asAllocatable(inputVal);
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(new Value[]{input}));
        this.getLIRGen().append(new AArch64ArithmeticOp.UnaryOp(op, result, input));
        return result;
    }

    private AllocatableValue moveSp(AllocatableValue val) {
        return this.getLIRGen().moveSp(val);
    }

    private AArch64ArithmeticOp getOpCode(Value val, AArch64ArithmeticOp intOp, AArch64ArithmeticOp floatOp) {
        return this.isNumericInteger(val.getPlatformKind()) ? intOp : floatOp;
    }

    @Override
    public Variable emitLoad(LIRKind loadKind, Value address, LIRFrameState state, MemoryOrderMode memoryOrder, MemoryExtendKind extendKind) {
        Variable result;
        AArch64Kind readKind = (AArch64Kind)loadKind.getPlatformKind();
        if (extendKind.isNotExtended()) {
            result = this.getLIRGen().newVariable(this.getLIRGen().toRegisterKind(loadKind));
        } else {
            assert (loadKind.isValue());
            AArch64Kind resultKind = extendKind.getExtendedBitSize() / 8 > AArch64Kind.DWORD.getSizeInBytes() ? AArch64Kind.QWORD : AArch64Kind.DWORD;
            result = this.getLIRGen().newVariable(LIRKind.value((PlatformKind)resultKind));
        }
        AArch64AddressValue loadAddress = this.getLIRGen().asAddressValue(address, readKind.getSizeInBytes() * 8);
        switch (memoryOrder) {
            case PLAIN: 
            case OPAQUE: {
                this.getLIRGen().append(new AArch64Move.LoadOp(readKind, extendKind, result, loadAddress, state));
                break;
            }
            case ACQUIRE: 
            case VOLATILE: {
                this.getLIRGen().append(new AArch64Move.LoadAcquireOp(readKind, extendKind, result, loadAddress, state));
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere("Unexpected memory order");
            }
        }
        return result;
    }

    @Override
    public void emitStore(ValueKind<?> lirKind, Value address, Value inputVal, LIRFrameState state, MemoryOrderMode memoryOrder) {
        JavaConstant c;
        AArch64Kind kind = (AArch64Kind)lirKind.getPlatformKind();
        AArch64AddressValue storeAddress = this.getLIRGen().asAddressValue(address, kind.getSizeInBytes() * 8);
        if (!MemoryOrderMode.ordersMemoryAccesses(memoryOrder) && kind.getSizeInBytes() <= 8 && LIRValueUtil.isJavaConstant(inputVal) && (c = LIRValueUtil.asJavaConstant(inputVal)).isDefaultForKind()) {
            this.getLIRGen().append(new AArch64Move.StoreZeroOp(kind, storeAddress, state));
            return;
        }
        AllocatableValue input = this.asAllocatable(inputVal);
        switch (memoryOrder) {
            case PLAIN: 
            case OPAQUE: {
                this.getLIRGen().append(new AArch64Move.StoreOp(kind, storeAddress, input, state));
                break;
            }
            case VOLATILE: 
            case RELEASE: {
                this.getLIRGen().append(new AArch64Move.StoreReleaseOp(kind, storeAddress, input, state));
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere("Unexpected memory order");
            }
        }
    }

    @Override
    public Value emitRound(Value value, ArithmeticLIRGeneratorTool.RoundingMode mode) {
        return this.emitUnary(switch (mode) {
            case ArithmeticLIRGeneratorTool.RoundingMode.NEAREST -> AArch64ArithmeticOp.FRINTN;
            case ArithmeticLIRGeneratorTool.RoundingMode.UP -> AArch64ArithmeticOp.FRINTP;
            case ArithmeticLIRGeneratorTool.RoundingMode.DOWN -> AArch64ArithmeticOp.FRINTM;
            case ArithmeticLIRGeneratorTool.RoundingMode.TRUNCATE -> AArch64ArithmeticOp.FRINTZ;
            default -> throw GraalError.shouldNotReachHereUnexpectedValue((Object)mode);
        }, value);
    }

    @Override
    public Value emitRoundFloatToInteger(Value value) {
        PlatformKind valuePlatformKind = value.getPlatformKind();
        GraalError.guarantee(valuePlatformKind == AArch64Kind.SINGLE || valuePlatformKind == AArch64Kind.DOUBLE, "Unsupported type");
        Variable result = this.getLIRGen().newVariable(LIRKind.value((PlatformKind)(value.getPlatformKind() == AArch64Kind.SINGLE ? AArch64Kind.DWORD : AArch64Kind.QWORD)));
        this.getLIRGen().append(new AArch64RoundFloatToIntegerOp(this.getLIRGen(), result, this.asAllocatable(value)));
        return result;
    }

    @Override
    public Variable emitReverseBits(Value input) {
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(input));
        this.getLIRGen().append(new AArch64BitSwapOp(result, this.asAllocatable(input)));
        return result;
    }

    @Override
    public Variable emitHalfFloatToFloat(Value input) {
        Variable result = this.getLIRGen().newVariable(LIRKind.value((PlatformKind)AArch64Kind.SINGLE));
        this.getLIRGen().append(new AArch64HalfFloatToFloatOp(this.getLIRGen(), (Value)result, (Value)this.asAllocatable(input)));
        return result;
    }

    @Override
    public Variable emitFloatToHalfFloat(Value input) {
        Variable result = this.getLIRGen().newVariable(LIRKind.value((PlatformKind)AArch64Kind.DWORD));
        this.getLIRGen().append(new AArch64FloatToHalfFloatOp(this.getLIRGen(), (Value)result, (Value)this.asAllocatable(input)));
        return result;
    }

    @Override
    public Variable emitNormalizedUnsignedCompare(LIRKind compareKind, Value x, Value y) {
        GraalError.guarantee(compareKind.getPlatformKind() == AArch64Kind.DWORD || compareKind.getPlatformKind() == AArch64Kind.QWORD, "unsupported subword comparison: %s", (Object)compareKind);
        Variable result = this.getLIRGen().newVariable(LIRKind.value((PlatformKind)AArch64Kind.DWORD));
        this.getLIRGen().append(new AArch64NormalizedUnsignedCompareOp(result, this.asAllocatable(x), this.asAllocatable(y)));
        return result;
    }
}

