/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.aarch64;

import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.type.DataPointerConstant;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRValueUtil;
import jdk.graal.compiler.lir.aarch64.AArch64AddressValue;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.aarch64.AArch64Move;
import jdk.graal.compiler.lir.gen.MoveFactory;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.Value;

public class AArch64MoveFactory
extends MoveFactory {
    @Override
    public LIRInstruction createMove(AllocatableValue dst, Value src) {
        boolean srcIsSlot = LIRValueUtil.isStackSlotValue(src);
        boolean dstIsSlot = LIRValueUtil.isStackSlotValue((Value)dst);
        if (LIRValueUtil.isConstantValue(src)) {
            return this.createLoad(dst, LIRValueUtil.asConstant(src));
        }
        if (src instanceof AArch64AddressValue) {
            return new AArch64Move.LoadAddressOp(dst, (AArch64AddressValue)src);
        }
        assert (src instanceof AllocatableValue) : src;
        if (srcIsSlot && dstIsSlot) {
            throw GraalError.shouldNotReachHere(String.valueOf(src.getClass()) + " " + String.valueOf(dst.getClass()));
        }
        return new AArch64Move.Move((AArch64Kind)dst.getPlatformKind(), dst, (AllocatableValue)src);
    }

    @Override
    public LIRInstruction createStackMove(AllocatableValue result, AllocatableValue input) {
        return new AArch64Move.Move((AArch64Kind)result.getPlatformKind(), result, input);
    }

    @Override
    public AArch64LIRInstruction createLoad(AllocatableValue dst, Constant src) {
        if (src instanceof JavaConstant) {
            JavaConstant javaConstant = (JavaConstant)src;
            return new AArch64Move.LoadInlineConstant(javaConstant, dst);
        }
        if (src instanceof DataPointerConstant) {
            return new AArch64Move.LoadDataOp(dst, (DataPointerConstant)src);
        }
        throw GraalError.shouldNotReachHereUnexpectedValue(src);
    }

    @Override
    public LIRInstruction createStackLoad(AllocatableValue result, Constant input) {
        return this.createLoad(result, input);
    }

    @Override
    public boolean canInlineConstant(Constant con) {
        if (con instanceof JavaConstant) {
            JavaConstant c = (JavaConstant)con;
            switch (c.getJavaKind()) {
                case Boolean: 
                case Byte: 
                case Char: 
                case Short: 
                case Int: 
                case Long: {
                    return NumUtil.isSignedNbit(17, c.asLong());
                }
                case Object: {
                    return c.isNull();
                }
                case Float: 
                case Double: {
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean allowConstantToStackMove(Constant value) {
        return false;
    }
}

