/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.amd64;

import jdk.graal.compiler.asm.amd64.AMD64BaseAssembler;
import jdk.graal.compiler.core.amd64.AMD64MoveFactoryBase;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.type.DataPointerConstant;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRValueUtil;
import jdk.graal.compiler.lir.amd64.AMD64AddressValue;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.amd64.AMD64Move;
import jdk.graal.compiler.lir.gen.MoveFactory;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.Value;

public abstract class AMD64MoveFactory
extends AMD64MoveFactoryBase {
    public AMD64MoveFactory(MoveFactory.BackupSlotProvider backupSlotProvider) {
        super(backupSlotProvider);
    }

    @Override
    public boolean canInlineConstant(Constant con) {
        if (con instanceof JavaConstant) {
            JavaConstant c = (JavaConstant)con;
            switch (c.getJavaKind()) {
                case Long: {
                    return NumUtil.isInt(c.asLong());
                }
                case Float: 
                case Double: {
                    return false;
                }
                case Object: {
                    return c.isNull();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mayEmbedConstantLoad(Constant constant) {
        return constant instanceof PrimitiveConstant && ((PrimitiveConstant)constant).getJavaKind().isNumericFloat();
    }

    @Override
    public boolean allowConstantToStackMove(Constant constant) {
        if (constant instanceof DataPointerConstant) {
            return false;
        }
        return !(constant instanceof JavaConstant) || AMD64Move.canMoveConst2Stack((JavaConstant)constant);
    }

    @Override
    public AMD64LIRInstruction createMove(AllocatableValue dst, Value src) {
        if (src instanceof AMD64AddressValue) {
            return new AMD64Move.LeaOp(dst, (AMD64AddressValue)src, AMD64BaseAssembler.OperandSize.QWORD);
        }
        if (LIRValueUtil.isConstantValue(src)) {
            return this.createLoad(dst, LIRValueUtil.asConstant(src));
        }
        if (ValueUtil.isRegister((Value)src) || LIRValueUtil.isStackSlotValue((Value)dst)) {
            return new AMD64Move.MoveFromRegOp((AMD64Kind)dst.getPlatformKind(), dst, (AllocatableValue)src);
        }
        return new AMD64Move.MoveToRegOp((AMD64Kind)dst.getPlatformKind(), dst, (AllocatableValue)src);
    }

    @Override
    public AMD64LIRInstruction createStackMove(AllocatableValue result, AllocatableValue input, Register scratchRegister, AllocatableValue backupSlot) {
        return new AMD64Move.AMD64StackMove(result, input, scratchRegister, backupSlot);
    }

    @Override
    public AMD64LIRInstruction createLoad(AllocatableValue dst, Constant src) {
        if (src instanceof JavaConstant) {
            return new AMD64Move.MoveFromConstOp(dst, (JavaConstant)src);
        }
        if (src instanceof DataPointerConstant) {
            return new AMD64Move.LeaDataOp(dst, (DataPointerConstant)src);
        }
        throw GraalError.shouldNotReachHere(String.format("unsupported constant: %s", src));
    }

    @Override
    public LIRInstruction createStackLoad(AllocatableValue result, Constant input) {
        if (input instanceof JavaConstant) {
            return new AMD64Move.MoveFromConstOp(result, (JavaConstant)input);
        }
        throw GraalError.shouldNotReachHere(String.format("unsupported constant for stack load: %s", input));
    }
}

