/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.amd64;

import java.util.ListIterator;
import jdk.graal.compiler.core.amd64.UseTrappingDivPhase;
import jdk.graal.compiler.java.DefaultSuitesCreator;
import jdk.graal.compiler.lir.amd64.phases.StackMoveOptimizationPhase;
import jdk.graal.compiler.lir.phases.LIRSuites;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.UseTrappingNullChecksPhase;
import jdk.graal.compiler.phases.tiers.CompilerConfiguration;
import jdk.graal.compiler.phases.tiers.LowTierContext;
import jdk.graal.compiler.phases.tiers.Suites;
import jdk.vm.ci.code.Architecture;

public abstract class AMD64SuitesCreator
extends DefaultSuitesCreator {
    public AMD64SuitesCreator(CompilerConfiguration compilerConfiguration, GraphBuilderConfiguration.Plugins plugins) {
        super(compilerConfiguration, plugins);
    }

    public AMD64SuitesCreator(CompilerConfiguration compilerConfiguration) {
        super(compilerConfiguration);
    }

    @Override
    public Suites createSuites(OptionValues options, Architecture arch) {
        Suites suites = super.createSuites(options, arch);
        ListIterator<BasePhase<LowTierContext>> position = suites.getLowTier().findPhase(UseTrappingNullChecksPhase.class);
        if (position != null) {
            position.previous();
            position.add(new UseTrappingDivPhase());
        }
        return suites;
    }

    @Override
    public LIRSuites createLIRSuites(OptionValues options) {
        LIRSuites lirSuites = super.createLIRSuites(options);
        if (StackMoveOptimizationPhase.Options.LIROptStackMoveOptimizer.getValue(options).booleanValue()) {
            lirSuites.getPostAllocationOptimizationStage().appendPhase(new StackMoveOptimizationPhase());
        }
        return lirSuites;
    }
}

