/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.common.alloc;

import java.util.BitSet;
import java.util.PriorityQueue;
import jdk.graal.compiler.core.common.alloc.BasicBlockOrderUtils;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.core.common.cfg.CodeEmissionOrder;
import jdk.graal.compiler.core.common.cfg.Loop;
import jdk.graal.compiler.options.OptionValues;

public class DefaultCodeEmissionOrder<T extends BasicBlock<T>>
implements CodeEmissionOrder<T> {
    protected int originalBlockCount;
    protected T startBlock;

    public DefaultCodeEmissionOrder(int originalBlockCount, T startBlock) {
        this.originalBlockCount = originalBlockCount;
        this.startBlock = startBlock;
    }

    @Override
    public int[] computeCodeEmittingOrder(OptionValues options, CodeEmissionOrder.ComputationTime computationTime) {
        BasicBlockOrderUtils.BlockList order = new BasicBlockOrderUtils.BlockList(this.originalBlockCount);
        BitSet visitedBlocks = new BitSet(this.originalBlockCount);
        PriorityQueue<T> worklist = BasicBlockOrderUtils.initializeWorklist(this.startBlock, visitedBlocks);
        DefaultCodeEmissionOrder.computeCodeEmittingOrder(order, worklist, visitedBlocks, computationTime);
        BasicBlockOrderUtils.checkStartBlock(order, this.startBlock);
        return order.toIdArray();
    }

    private static <T extends BasicBlock<T>> void computeCodeEmittingOrder(BasicBlockOrderUtils.BlockList<T> order, PriorityQueue<T> worklist, BitSet visitedBlocks, CodeEmissionOrder.ComputationTime computationTime) {
        while (!worklist.isEmpty()) {
            BasicBlock nextImportantPath = (BasicBlock)worklist.poll();
            DefaultCodeEmissionOrder.addPathToCodeEmittingOrder(nextImportantPath, order, worklist, visitedBlocks, computationTime);
        }
    }

    private static <T extends BasicBlock<T>> void addPathToCodeEmittingOrder(T initialBlock, BasicBlockOrderUtils.BlockList<T> order, PriorityQueue<T> worklist, BitSet visitedBlocks, CodeEmissionOrder.ComputationTime computationTime) {
        T block = initialBlock;
        while (block != null && !order.isScheduled(block)) {
            if (!DefaultCodeEmissionOrder.skipLoopHeader(block)) {
                if (block.isLoopHeader()) {
                    block.setAlign(true);
                }
                order.add(block);
            }
            if (block.isLoopEnd()) {
                Loop<T> blockLoop = block.getLoop();
                for (int i = 0; i < block.getSuccessorCount(); ++i) {
                    Loop<T> loop;
                    T succ = block.getSuccessorAt(i);
                    if (order.isScheduled(succ) || (loop = ((BasicBlock)succ).getLoop()) != blockLoop || succ != loop.getHeader() || !DefaultCodeEmissionOrder.skipLoopHeader(succ)) continue;
                    order.add(loop.getHeader());
                    boolean alignSucc = true;
                    if (loop.isInverted() && loop.getBlocks().size() < 2) {
                        alignSucc = false;
                    }
                    if (!alignSucc) continue;
                    for (int j = 0; j < ((BasicBlock)loop.getHeader()).getSuccessorCount(); ++j) {
                        T successor = ((BasicBlock)loop.getHeader()).getSuccessorAt(j);
                        if (((BasicBlock)successor).getLoopDepth() != block.getLoopDepth()) continue;
                        ((BasicBlock)successor).setAlign(true);
                    }
                }
            }
            T mostLikelySuccessor = BasicBlockOrderUtils.findAndMarkMostLikelySuccessor(block, order, visitedBlocks, computationTime, worklist);
            BasicBlockOrderUtils.enqueueSuccessors(block, worklist, visitedBlocks);
            block = mostLikelySuccessor;
        }
    }

    protected static <T extends BasicBlock<T>> boolean skipLoopHeader(BasicBlock<T> block) {
        if (block.isLoopHeader() && !block.isLoopEnd() && block.numBackedges() == 1) {
            for (int i = 0; i < block.getPredecessorCount(); ++i) {
                T pred = block.getPredecessorAt(i);
                if (!((BasicBlock)pred).isLoopEnd() || ((BasicBlock)pred).getLoop().getHeader() != block) continue;
                return true;
            }
        }
        return false;
    }
}

