/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.common.calc;

import jdk.graal.compiler.core.common.calc.FloatConvertCategory;
import jdk.graal.compiler.core.common.type.FloatStamp;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.PrimitiveStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.GraalError;

public enum FloatConvert {
    F2I(FloatConvertCategory.FloatingPointToInteger, 32),
    D2I(FloatConvertCategory.FloatingPointToInteger, 64),
    F2L(FloatConvertCategory.FloatingPointToInteger, 32),
    D2L(FloatConvertCategory.FloatingPointToInteger, 64),
    I2F(FloatConvertCategory.IntegerToFloatingPoint, 32),
    L2F(FloatConvertCategory.IntegerToFloatingPoint, 64),
    D2F(FloatConvertCategory.FloatingPointToFloatingPoint, 64),
    I2D(FloatConvertCategory.IntegerToFloatingPoint, 32),
    L2D(FloatConvertCategory.IntegerToFloatingPoint, 64),
    F2D(FloatConvertCategory.FloatingPointToFloatingPoint, 32);

    private final FloatConvertCategory category;
    private final int inputBits;

    private FloatConvert(FloatConvertCategory category, int inputBits) {
        this.category = category;
        this.inputBits = inputBits;
    }

    public FloatConvertCategory getCategory() {
        return this.category;
    }

    public FloatConvert reverse() {
        switch (this.ordinal()) {
            case 6: {
                return F2D;
            }
            case 1: {
                return I2D;
            }
            case 3: {
                return L2D;
            }
            case 9: {
                return D2F;
            }
            case 0: {
                return I2F;
            }
            case 2: {
                return L2F;
            }
            case 7: {
                return D2I;
            }
            case 4: {
                return F2I;
            }
            case 8: {
                return D2L;
            }
            case 5: {
                return F2L;
            }
        }
        throw GraalError.shouldNotReachHereUnexpectedValue((Object)this);
    }

    public int getInputBits() {
        return this.inputBits;
    }

    public static FloatConvert forStamps(Stamp from, Stamp to) {
        int fromBits = PrimitiveStamp.getBits(from);
        int toBits = PrimitiveStamp.getBits(to);
        if (from instanceof FloatStamp) {
            if (to instanceof FloatStamp) {
                if (fromBits == 32 && toBits == 64) {
                    return F2D;
                }
                if (fromBits == 64 && toBits == 32) {
                    return D2F;
                }
            } else if (to instanceof IntegerStamp) {
                if (fromBits == 32 && toBits == 32) {
                    return F2I;
                }
                if (fromBits == 32 && toBits == 64) {
                    return F2L;
                }
                if (fromBits == 64 && toBits == 32) {
                    return D2I;
                }
                if (fromBits == 64 && toBits == 64) {
                    return D2L;
                }
            }
        } else if (from instanceof IntegerStamp && to instanceof FloatStamp) {
            if (fromBits == 32 && toBits == 32) {
                return I2F;
            }
            if (fromBits == 32 && toBits == 64) {
                return I2D;
            }
            if (fromBits == 64 && toBits == 32) {
                return L2F;
            }
            if (fromBits == 64 && toBits == 64) {
                return L2D;
            }
        }
        return null;
    }
}

